/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.enums.Operation;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerStatModifier;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class StatMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String OPERATION = "operation";
    private static final String AMOUNT = "amount";
    private static final String SECONDS = "seconds";
    private static final String STACKABLE = "stackable";
    private final Map<Integer, Map<String, StatTask>> tasks = new HashMap<Integer, Map<String, StatTask>>();

    @Override
    public String getKey() {
        return "stat";
    }

    @Override
    protected void doCleanUp(LivingEntity user) {
        Map<String, StatTask> casterTasks = this.tasks.remove(user.getEntityId());
        if (casterTasks != null) {
            casterTasks.values().forEach(StatTask::stop);
        }
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        String key = this.settings.getString(KEY, "");
        if (targets.size() == 0) {
            return false;
        }
        Map casterTasks = this.tasks.computeIfAbsent(caster.getEntityId(), HashMap::new);
        double amount = this.parseValues(caster, AMOUNT, level, 5.0);
        double seconds = this.parseValues(caster, SECONDS, level, 3.0);
        boolean stackable = this.settings.getBool(STACKABLE, false);
        int ticks = (int)(seconds * 20.0);
        String operation = this.settings.getString(OPERATION, "MULTIPLY_PERCENTAGE");
        boolean worked = false;
        for (LivingEntity target : targets) {
            if (!(target instanceof Player)) continue;
            worked = true;
            PlayerData data = Fabled.getData((OfflinePlayer)((Player)target));
            PlayerStatModifier modifier = new PlayerStatModifier("fabled.mechanic.stat_mechanic", amount, Operation.valueOf(operation), false);
            if (casterTasks.containsKey(data.getPlayerName()) && !stackable) {
                StatTask old = (StatTask)((Object)casterTasks.remove(data.getPlayerName()));
                data.removeStatModifier(old.modifier.getUUID(), false);
                data.addStatModifier(key, modifier, true);
                old.cancel();
            } else {
                data.addStatModifier(key, modifier, true);
            }
            StatTask task = new StatTask(caster.getEntityId(), data, modifier);
            casterTasks.put(data.getPlayerName(), task);
            if (ticks < 0) continue;
            Fabled.schedule(task, ticks);
        }
        return worked;
    }

    private class StatTask
    extends BukkitRunnable {
        private final PlayerData data;
        private final PlayerStatModifier modifier;
        private final int id;
        private boolean running = false;
        private boolean stopped = false;

        StatTask(int id, PlayerData data, PlayerStatModifier modifier) {
            this.id = id;
            this.data = data;
            this.modifier = modifier;
        }

        public void stop() {
            if (!this.stopped) {
                this.stopped = true;
                this.run();
                if (this.running) {
                    this.cancel();
                }
            }
        }

        public BukkitTask runTaskLater(Plugin plugin, long delay) {
            this.running = true;
            return super.runTaskLater(plugin, delay);
        }

        public void run() {
            this.data.removeStatModifier(this.modifier.getUUID(), true);
            if (StatMechanic.this.tasks.containsKey(this.id)) {
                StatMechanic.this.tasks.get(this.id).remove(this.data.getPlayerName());
            }
            this.running = false;
        }
    }
}

