/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.ThrowableProjectile;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import studio.magemonkey.codex.util.NamespaceResolver;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.particle.EffectPlayer;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.api.particle.ParticleSettings;
import studio.magemonkey.fabled.api.particle.target.EntityTarget;
import studio.magemonkey.fabled.api.projectile.CustomProjectile;
import studio.magemonkey.fabled.api.projectile.ParticleProjectile;
import studio.magemonkey.fabled.api.projectile.ProjectileCallback;
import studio.magemonkey.fabled.api.target.TargetHelper;
import studio.magemonkey.fabled.api.util.Nearby;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.TempEntity;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;
import studio.magemonkey.fabled.task.RemoveTask;
import studio.magemonkey.fabled.task.RepeatingEntityTask;

public class ProjectileMechanic
extends MechanicComponent {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final String PROJECTILE = "projectile";
    private static final String OVERRIDE_ITEM = "override-item";
    private static final String MATERIAL = "material";
    private static final String ENCHANTED = "enchanted";
    private static final String DURABILITY = "durability";
    private static final String CMD = "custom-model-data";
    private static final String FLAMING = "flaming";
    private static final String COST = "cost";
    private static final String VELOCITY = "velocity";
    private static final String LIFESPAN = "lifespan";
    private static final String SPREAD = "spread";
    private static final String AMOUNT = "amount";
    private static final String ANGLE = "angle";
    private static final String HEIGHT = "height";
    private static final String RADIUS = "rain-radius";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";
    private static final String USE_EFFECT = "use-effect";
    private static final String EFFECT_KEY = "effect-key";
    public static final String HOMING = "homing";
    public static final String HOMING_TARGET = "target";
    public static final String HOMING_DIST = "homing-distance";
    public static final String REMEMBER = "remember-key";
    public static final String CORRECTION = "correction";
    public static final String WALL = "wall";
    private static final HashMap<String, Class<? extends Projectile>> PROJECTILES = new HashMap<String, Class<? extends Projectile>>(){
        {
            this.put("arrow", Arrow.class);
            this.put("egg", Egg.class);
            this.put("ghast fireball", LargeFireball.class);
            this.put("snowball", Snowball.class);
            this.put("fishing hook", FishHook.class);
        }
    };
    private static final HashMap<String, Material> MATERIALS = new HashMap<String, Material>(){
        {
            this.put("arrow", Material.ARROW);
            this.put("egg", Material.EGG);
            this.put("snowball", ProjectileMechanic.snowBall());
        }
    };

    private static Class<? extends Projectile> getProjectileClass(String projectileName) {
        StringBuilder conditionedName = new StringBuilder();
        for (String word : projectileName.split(" ")) {
            conditionedName.append(word.substring(0, 1).toUpperCase(Locale.US)).append(word.substring(1).toLowerCase());
        }
        try {
            return Class.forName("org.bukkit.entity." + conditionedName);
        }
        catch (ClassNotFoundException e) {
            return PROJECTILES.get(projectileName);
        }
    }

    private static Material snowBall() {
        for (Material material : Material.values()) {
            if (!material.name().startsWith("SNOW") || !material.name().endsWith("BALL")) continue;
            return material;
        }
        return Material.SNOW;
    }

    @Override
    public String getKey() {
        return PROJECTILE;
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        Object player;
        int amount = (int)this.parseValues(caster, AMOUNT, level, 1.0);
        double speed = this.parseValues(caster, VELOCITY, level, 2.0);
        boolean flaming = this.settings.getString(FLAMING, "false").equalsIgnoreCase("true");
        String spread = this.settings.getString(SPREAD, "cone").toLowerCase();
        String projectile = this.settings.getString(PROJECTILE, "arrow").toLowerCase();
        String cost = this.settings.getString(COST, "none").toLowerCase();
        Class<? extends Projectile> type = ProjectileMechanic.getProjectileClass(projectile);
        if (type == null) {
            type = Arrow.class;
        }
        if (cost.equals("one") || cost.equals("all")) {
            Material mat = MATERIALS.get(this.settings.getString(PROJECTILE, "arrow").toLowerCase());
            if (mat == null || !(caster instanceof Player)) {
                return false;
            }
            player = (Player)caster;
            if (cost.equals("one") && !player.getInventory().contains(mat, 1)) {
                return false;
            }
            if (cost.equals("all") && !player.getInventory().contains(mat, amount)) {
                return false;
            }
            if (cost.equals("one")) {
                player.getInventory().removeItem(new ItemStack[]{new ItemStack(mat)});
            } else {
                player.getInventory().removeItem(new ItemStack[]{new ItemStack(mat, amount)});
            }
        }
        final ArrayList<Projectile> projectiles = new ArrayList<Projectile>();
        for (LivingEntity target : targets) {
            Location location = target.getEyeLocation();
            Vector offset = location.getDirection().setY(0).normalize();
            offset.multiply(this.parseValues(caster, FORWARD, level, 0.0)).add(offset.clone().crossProduct(UP).multiply(this.parseValues(caster, RIGHT, level, 0.0)));
            location.add(offset).add(0.0, this.parseValues(caster, UPWARD, level, 0.0), 0.0);
            if (spread.equals("rain")) {
                Vector vel = new Vector(0.0, speed, 0.0);
                for (Location loc : CustomProjectile.calcRain(location, this.parseValues(caster, RADIUS, level, 2.0), this.parseValues(caster, HEIGHT, level, 8.0), amount)) {
                    Projectile p = caster.launchProjectile(type);
                    p.teleport(loc);
                    p.setVelocity(vel);
                    projectiles.add(p);
                }
                continue;
            }
            Vector dir = location.getDirection();
            if (spread.equals("horizontal cone")) {
                dir.setY(0);
                dir.normalize();
            }
            List<Vector> dirs = CustomProjectile.calcSpread(dir, this.parseValues(caster, ANGLE, level, 30.0), amount);
            for (Vector d : dirs) {
                Projectile p = caster.launchProjectile(type);
                p.teleport(location);
                p.setVelocity(d.multiply(speed));
                projectiles.add(p);
            }
        }
        for (Projectile p : projectiles) {
            if (flaming) {
                p.setFireTicks(Integer.MAX_VALUE);
            }
            if (type.getName().contains("Arrow")) {
                p.setTicksLived(1180);
                try {
                    try {
                        AbstractArrow arrow = (AbstractArrow)p;
                        arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
                    }
                    catch (NoClassDefFoundError e) {
                        Arrow arrow = (Arrow)p;
                        Class<?> pickupStatusClass = Class.forName("org.bukkit.Arrow$PickupStatus");
                        Arrow.class.getMethod("setPickupStatus", pickupStatusClass).invoke((Object)arrow, pickupStatusClass.getMethod("valueOf", String.class).invoke(null, "DISALLOWED"));
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodError | NoSuchMethodException | InvocationTargetException e) {
                    // empty catch block
                }
            }
            Fabled.setMeta((Metadatable)p, "skill_level", level);
            Fabled.setMeta((Metadatable)p, "pmCallback", this);
        }
        if (this.settings.getBool(OVERRIDE_ITEM)) {
            ItemStack itemStack = new ItemStack(Material.valueOf((String)this.settings.getString(MATERIAL, "Snowball").toUpperCase(Locale.US).replace(" ", "_")));
            ItemMeta meta = itemStack.getItemMeta();
            if (meta != null) {
                if (this.settings.getBool(ENCHANTED, false)) {
                    meta.addEnchant(NamespaceResolver.getEnchantment((String[])new String[]{"UNBREAKING", "DURABILITY"}), 1, false);
                }
                meta.setCustomModelData(Integer.valueOf(this.settings.getInt(CMD, 0)));
                if (meta instanceof Damageable) {
                    ((Damageable)meta).setDamage(this.settings.getInt(DURABILITY));
                }
                itemStack.setItemMeta(meta);
            }
            for (Projectile p : projectiles) {
                if (!(p instanceof ThrowableProjectile)) continue;
                ((ThrowableProjectile)p).setItem(itemStack);
            }
        }
        if (this.settings.getBool(USE_EFFECT, false)) {
            player = new EffectPlayer(this.settings);
            for (Projectile p : projectiles) {
                ((EffectPlayer)player).start(new EntityTarget((Entity)p), this.settings.getString(EFFECT_KEY, this.skill.getName()), Integer.MAX_VALUE, level, true);
            }
        }
        if (this.settings.getBool(HOMING, false)) {
            String target = this.settings.getString(HOMING_TARGET, "nearest");
            Function<Projectile, LivingEntity> homing = target.equalsIgnoreCase("remember target") ? proj -> {
                Object data = Objects.requireNonNull(DynamicSkill.getCastData((LivingEntity)proj.getShooter())).getRaw(this.settings.getString(REMEMBER, HOMING_TARGET));
                if (data == null) {
                    return null;
                }
                try {
                    return ((List)data).stream().filter(tar -> this.settings.getBool(WALL, false) || !TargetHelper.isObstructed(proj.getLocation(), tar.getEyeLocation())).min(Comparator.comparingDouble(o -> o.getLocation().distanceSquared(proj.getLocation()))).orElse(null);
                }
                catch (ClassCastException e) {
                    return null;
                }
            } : proj -> Nearby.getLivingNearby(proj.getLocation(), this.settings.getAttr(HOMING_DIST, 0, 20.0)).stream().filter(tar -> {
                if (tar == proj.getShooter()) {
                    return false;
                }
                return Fabled.getSettings().isValidTarget((LivingEntity)tar);
            }).filter(tar -> this.settings.getBool(WALL, false) || !TargetHelper.isObstructed(proj.getLocation(), tar.getEyeLocation())).min(Comparator.comparingDouble(o -> o.getLocation().distanceSquared(proj.getLocation()))).orElse(null);
            double correction = this.settings.getAttr(CORRECTION, 0, 0.2);
            new RepeatingEntityTask<Projectile>(projectiles, proj -> {
                LivingEntity tar = (LivingEntity)homing.apply((Projectile)proj);
                if (tar != null) {
                    Vector acceleration = tar.getBoundingBox().getCenter().subtract(proj.getBoundingBox().getCenter()).normalize().multiply(speed).subtract(proj.getVelocity());
                    double length = acceleration.length();
                    acceleration.multiply(1.0 / length).multiply(Math.min(length, correction));
                    proj.setVelocity(proj.getVelocity().add(acceleration));
                }
            });
        }
        new RepeatingEntityTask<Projectile>(projectiles, proj -> ParticleHelper.play(proj.getLocation(), this.settings));
        new RemoveTask(projectiles, (int)this.parseValues(caster, LIFESPAN, level, 9999.0) * 20){

            @Override
            public void run() {
                super.run();
                if (ProjectileMechanic.this.settings.getBool("on-expire", false)) {
                    for (Projectile projectile1 : projectiles) {
                        ProjectileMechanic.this.callback(projectile1, null);
                    }
                }
            }
        };
        return !targets.isEmpty();
    }

    public void callback(Projectile projectile, LivingEntity hit) {
        if (hit == null) {
            hit = new TempEntity(projectile.getLocation());
        }
        LivingEntity finalHit = hit;
        Bukkit.getScheduler().runTaskLater((Plugin)Fabled.inst(), () -> {
            ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
            targets.add(finalHit);
            if (projectile.getShooter() != null) {
                this.executeChildren((LivingEntity)projectile.getShooter(), Fabled.getMetaInt((Metadatable)projectile, "skill_level"), targets, this.skill.isForced((LivingEntity)projectile.getShooter()));
            }
            Fabled.removeMeta((Metadatable)projectile, "pmCallback");
            projectile.remove();
        }, 1L);
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, final int level, final Supplier<List<LivingEntity>> targetSupplier) {
        final ArrayList targets = new ArrayList();
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                double gravity;
                String type;
                targets.clear();
                int amount = (int)ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.AMOUNT, level, 1.0);
                String spread = ProjectileMechanic.this.settings.getString(ProjectileMechanic.SPREAD, "cone").toLowerCase();
                int lifespan = (int)(ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.LIFESPAN, level, 9999.0) * 20.0);
                double drag = switch (type = ProjectileMechanic.this.settings.getString(ProjectileMechanic.PROJECTILE, "arrow").toLowerCase()) {
                    case "egg", "snowball", "splash potion", "ender pearl", "thrown exp bottle" -> {
                        gravity = -0.03;
                        yield 0.01;
                    }
                    case "arrow", "spectral arrow", "trident" -> {
                        gravity = -0.05;
                        yield 0.01;
                    }
                    case "llama spit" -> {
                        gravity = -0.06;
                        yield 0.01;
                    }
                    case "fishing hook" -> {
                        gravity = -0.03;
                        yield 0.08;
                    }
                    default -> {
                        gravity = 0.0;
                        yield 0.0;
                    }
                };
                Settings copy = new Settings(ProjectileMechanic.this.settings);
                copy.set(ProjectileMechanic.VELOCITY, ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.VELOCITY, level, 1.0), 0.0);
                copy.set("particles", ProjectileMechanic.this.parseValues((LivingEntity)caster, "particles", level, 1.0), 0.0);
                copy.set("radius", ProjectileMechanic.this.parseValues((LivingEntity)caster, "radius", level, 0.0), 0.0);
                copy.set("collision-radius", switch (type) {
                    case "arrow", "spectral arrow", "trident" -> 0.25;
                    case "dragon fireball", "fireball" -> 0.5;
                    case "shulker bullet", "small fireball", "wither skull" -> 0.15625;
                    default -> 0.125;
                }, 0.0);
                copy.set("gravity", gravity, 0.0);
                copy.set("drag", drag, 0.0);
                copy.set("period", ProjectileMechanic.this.preview.getInt("path-steps", 2));
                ProjectileCallback callback = (projectile, hit) -> {
                    if (hit == null) {
                        hit = new TempEntity(projectile.getLocation());
                    }
                    targets.add(hit);
                    if (ProjectileMechanic.this.preview.getBool("per-target")) {
                        ParticleHelper.play(hit.getLocation(), ProjectileMechanic.this.preview, Set.of(caster), "per-target-", ProjectileMechanic.this.preview.getBool("per-target-hitbox") ? hit.getBoundingBox() : null);
                    }
                };
                ArrayList<ParticleProjectile> list = new ArrayList<ParticleProjectile>();
                for (LivingEntity target : (List)targetSupplier.get()) {
                    Location location = target.getEyeLocation();
                    Vector offset = location.getDirection().setY(0).normalize();
                    offset.multiply(ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.FORWARD, level, 0.0)).add(offset.clone().crossProduct(UP).multiply(ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.RIGHT, level, 0.0)));
                    location.add(offset).add(0.0, ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.UPWARD, level, 0.0), 0.0);
                    if (spread.equals("rain")) {
                        list.addAll(ParticleProjectile.rain((LivingEntity)caster, level, location, copy, ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.RADIUS, level, 2.0), ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.HEIGHT, level, 8.0), amount, callback, lifespan));
                    } else {
                        Vector dir = location.getDirection();
                        if (spread.equals("horizontal cone")) {
                            dir.setY(0);
                            dir.normalize();
                        }
                        list.addAll(ParticleProjectile.spread((LivingEntity)caster, level, dir, location, copy, ProjectileMechanic.this.parseValues((LivingEntity)caster, ProjectileMechanic.ANGLE, level, 30.0), amount, callback, lifespan));
                    }
                    for (ParticleProjectile p : list) {
                        Fabled.setMeta(p, "skill_level", level);
                        p.setAllyEnemy(true, true);
                    }
                    Consumer<Location> onStep = ProjectileMechanic.this.preview.getBool("path") ? loc -> new ParticleSettings(ProjectileMechanic.this.preview, "path-").instance(caster, loc.getX(), loc.getY(), loc.getZ()) : loc -> {};
                    for (ParticleProjectile p : list) {
                        p.setOnStep(onStep);
                    }
                    for (ParticleProjectile p : list) {
                        while (p.isValid()) {
                            p.run();
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)Fabled.inst(), 0L, (long)Math.max(1, this.preview.getInt("period", 5)));
        onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        this.playChildrenPreviews(onPreviewStop, caster, level, () -> targets);
    }
}

