/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.List;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.api.util.FlagManager;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;
import studio.magemonkey.fabled.hook.PluginChecker;

public class PermissionMechanic
extends MechanicComponent {
    private static final String PERM = "perm";
    private static final String SECONDS = "seconds";

    @Override
    public String getKey() {
        return "permission";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0 || !this.settings.has(PERM) || !PluginChecker.isVaultPermissionsActive()) {
            return false;
        }
        String key = this.settings.getString(PERM);
        double seconds = this.parseValues(caster, SECONDS, level, 3.0);
        int ticks = (int)(seconds * 20.0);
        for (LivingEntity target : targets) {
            if (target.hasPermission(key)) continue;
            FlagManager.addFlag(target, "perm:" + key, ticks);
        }
        return targets.size() > 0;
    }
}

