/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class PassiveMechanic
extends MechanicComponent {
    private static final String PERIOD = "seconds";
    private final Map<Integer, PassiveTask> tasks = new HashMap<Integer, PassiveTask>();

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (this.tasks.containsKey(caster.getEntityId()) || targets.isEmpty()) {
            return false;
        }
        int period = (int)(this.parseValues(caster, PERIOD, level, 1.0) * 20.0);
        PassiveTask task = new PassiveTask(caster, level, targets, period);
        this.tasks.put(caster.getEntityId(), task);
        return true;
    }

    @Override
    public String getKey() {
        return "passive";
    }

    @Override
    protected void doCleanUp(LivingEntity caster) {
        PassiveTask task = this.tasks.remove(caster.getEntityId());
        if (task != null) {
            task.cancel();
        }
    }

    private class PassiveTask
    extends BukkitRunnable {
        private final List<LivingEntity> targets;
        private final LivingEntity caster;
        private int level;

        PassiveTask(LivingEntity caster, int level, List<LivingEntity> targets, int period) {
            this.targets = new ArrayList<LivingEntity>(targets);
            this.caster = caster;
            this.level = level;
            Fabled.schedule(this, 5, period);
        }

        public void cancel() {
            super.cancel();
            PassiveMechanic.this.tasks.remove(this.caster.getEntityId());
        }

        public void run() {
            PlayerSkill data;
            for (int i = 0; i < this.targets.size(); ++i) {
                if (!this.targets.get(i).isDead() && this.targets.get(i).isValid()) continue;
                this.targets.remove(i);
            }
            if (!PassiveMechanic.this.skill.isActive(this.caster) || this.targets.isEmpty()) {
                this.cancel();
                return;
            }
            if (!(!(this.caster instanceof Player) || (data = PassiveMechanic.this.getSkillData(this.caster)) != null && data.isUnlocked() && ((Player)this.caster).isOnline())) {
                this.cancel();
                return;
            }
            this.level = PassiveMechanic.this.skill.getActiveLevel(this.caster);
            PassiveMechanic.this.executeChildren(this.caster, this.level, this.targets, PassiveMechanic.this.skill.isForced(this.caster));
            if (PassiveMechanic.this.skill.checkCancelled()) {
                this.cancel();
            }
        }
    }
}

