/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class MountMechanic
extends MechanicComponent {
    private static final String TYPE = "type";
    private static final String MAX = "max";

    @Override
    public String getKey() {
        return "mount";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        String type = this.settings.getString(TYPE, "caster->target");
        int max = (int)this.parseValues(caster, MAX, level, 1.0);
        if (type.equalsIgnoreCase("caster->target")) {
            for (LivingEntity target : targets) {
                int targetSize;
                int casterSize = this.getStackSize((Entity)caster);
                if (casterSize + (targetSize = this.getStackSize((Entity)target)) + 1 <= max) {
                    Entity bottom = this.getBottomOfStack((Entity)caster);
                    Entity targetTop = this.getTopOfStack((Entity)target);
                    if (targetTop.equals(bottom)) {
                        return false;
                    }
                    targetTop.addPassenger(bottom);
                    continue;
                }
                break;
            }
        } else if (type.equalsIgnoreCase("target->caster")) {
            for (LivingEntity target : targets) {
                int targetSize;
                int casterSize = this.getStackSize((Entity)caster);
                if (casterSize + (targetSize = this.getStackSize((Entity)target)) + 1 <= max) {
                    Entity top = this.getTopOfStack((Entity)caster);
                    if (top.equals(target)) {
                        return false;
                    }
                    top.addPassenger((Entity)target);
                    continue;
                }
                break;
            }
        } else {
            return false;
        }
        return true;
    }

    private int getStackSize(Entity entity) {
        int size = 0;
        entity = this.getBottomOfStack(entity);
        while (!entity.getPassengers().isEmpty()) {
            ++size;
            entity = (Entity)entity.getPassengers().get(0);
        }
        return size;
    }

    private Entity getBottomOfStack(Entity entity) {
        Entity bottom = entity;
        while (bottom.getVehicle() != null) {
            bottom = bottom.getVehicle();
        }
        return bottom;
    }

    private Entity getTopOfStack(Entity entity) {
        Entity top = entity;
        while (!top.getPassengers().isEmpty()) {
            top = (Entity)top.getPassengers().get(0);
        }
        return top;
    }
}

