/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.enums.ManaCost;
import studio.magemonkey.fabled.api.enums.ManaSource;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class ManaMechanic
extends MechanicComponent {
    private static final String TYPE = "type";
    private static final String VALUE = "value";

    @Override
    public String getKey() {
        return "mana";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        boolean percent = this.settings.getString(TYPE, "mana").toLowerCase().equals("percent");
        double value = this.parseValues(caster, VALUE, level, 1.0);
        boolean worked = false;
        for (LivingEntity target : targets) {
            if (!(target instanceof Player)) continue;
            worked = true;
            PlayerData data = Fabled.getData((OfflinePlayer)((Player)target));
            double amount = percent ? data.getMaxMana() * value / 100.0 : value;
            if (amount > 0.0) {
                data.giveMana(amount, ManaSource.SKILL);
                continue;
            }
            data.useMana(-amount, ManaCost.SKILL_EFFECT);
        }
        return worked;
    }
}

