/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.Metadatable;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class LightningMechanic
extends MechanicComponent {
    private static final Vector up = new Vector(0, 1, 0);
    private static final String DAMAGE = "damage";
    private static final String GROUP = "group";
    private static final String CASTER = "caster";
    private static final String FORWARD = "forward";
    private static final String RIGHT = "right";
    private static final String FIRE = "fire";

    @Override
    public String getKey() {
        return "lightning";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0) {
            return false;
        }
        double forward = this.parseValues(caster, FORWARD, level, 0.0);
        double right = this.parseValues(caster, RIGHT, level, 0.0);
        boolean startFires = this.settings.getBool(FIRE, true);
        for (LivingEntity target : targets) {
            Vector dir = target.getLocation().getDirection().setY(0).normalize();
            Vector nor = dir.clone().crossProduct(up);
            Location loc = target.getLocation().add(dir.multiply(forward).add(nor.multiply(right)));
            LightningStrike lightning = target.getWorld().strikeLightning(loc);
            Fabled.setMeta((Metadatable)lightning, "pmCallback", new Callback(caster, level, force));
            if (startFires) continue;
            Fabled.setMeta((Metadatable)lightning, "noFire", "valNotUsed");
        }
        return targets.size() > 0;
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, Player caster, int level, Supplier<List<LivingEntity>> targetSupplier) {
        super.playPreview(onPreviewStop, caster, level, () -> {
            HashSet<LivingEntity> newTargets = new HashSet<LivingEntity>();
            for (LivingEntity target : (List)targetSupplier.get()) {
                Location location = target.getLocation();
                location = new Location(null, (double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ());
                BoundingBox boundingBox = BoundingBox.of((Location)location, (double)3.0, (double)6.0, (double)3.0);
                for (LivingEntity livingEntity : target.getWorld().getLivingEntities()) {
                    if (!boundingBox.overlaps(livingEntity.getBoundingBox())) continue;
                    newTargets.add(livingEntity);
                }
            }
            return new ArrayList(newTargets);
        });
    }

    public class Callback {
        private final LivingEntity caster;
        private final int level;
        private final boolean force;
        private final List<LivingEntity> struckEntities = new ArrayList<LivingEntity>();

        public Callback(LivingEntity caster, int level, boolean force) {
            this.caster = caster;
            this.level = level;
            this.force = force;
        }

        public double execute(LivingEntity entity) {
            if (this.struckEntities.contains(entity)) {
                return -1.0;
            }
            boolean canTarget = false;
            if (Fabled.getSettings().isValidTarget(entity)) {
                String group = LightningMechanic.this.settings.getString(LightningMechanic.GROUP, "ENEMY").toUpperCase(Locale.US);
                canTarget = this.caster != entity ? group.equals("BOTH") || group.equals("ALLY") == Fabled.getSettings().isAlly(this.caster, entity) : LightningMechanic.this.settings.getBool(LightningMechanic.CASTER, false);
            }
            if (canTarget) {
                LightningMechanic.this.executeChildren(this.caster, this.level, Collections.singletonList(entity), this.force);
                this.struckEntities.add(entity);
                return LightningMechanic.this.parseValues(this.caster, LightningMechanic.DAMAGE, this.level, 5.0);
            }
            return -1.0;
        }
    }
}

