/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class LaunchMechanic
extends MechanicComponent {
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";
    private static final String RELATIVE = "relative";
    private static final String RESET_Y = "reset-y";
    private Vector up = new Vector(0, 1, 0);

    @Override
    public String getKey() {
        return "launch";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        boolean resetY = this.settings.getBool(RESET_Y, true);
        double forward = this.parseValues(caster, FORWARD, level, 0.0);
        double upward = this.parseValues(caster, UPWARD, level, 0.0);
        double right = this.parseValues(caster, RIGHT, level, 0.0);
        String relative = this.settings.getString(RELATIVE, "target").toLowerCase();
        for (LivingEntity target : targets) {
            Vector dir = relative.equals("caster") ? caster.getLocation().getDirection() : (relative.equals("between") ? target.getLocation().toVector().subtract(caster.getLocation().toVector()) : target.getLocation().getDirection());
            if (resetY) {
                dir.setY(0);
            }
            dir.normalize();
            Vector nor = dir.clone().crossProduct(this.up);
            dir.multiply(forward);
            dir.add(nor.multiply(right)).setY(dir.getY() + upward);
            target.setVelocity(dir);
        }
        return !targets.isEmpty();
    }
}

