/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class FireMechanic
extends MechanicComponent {
    public static final String META_KEY = "fireMechanic";
    private static final String SECONDS = "seconds";
    private static final String DAMAGE = "damage";

    @Override
    public String getKey() {
        return "fire";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0) {
            return false;
        }
        double seconds = this.parseValues(caster, SECONDS, level, 3.0);
        double damage = this.parseValues(caster, DAMAGE, level, 1.0);
        int ticks = (int)(seconds * 20.0);
        targets.forEach(target -> {
            int newTicks = ticks <= 0 ? 0 : Math.max(ticks, target.getFireTicks());
            target.setFireTicks(newTicks);
            Fabled.setMeta((Metadatable)target, META_KEY, damage);
            Bukkit.getScheduler().runTaskLater((Plugin)Fabled.inst(), () -> {
                if (target.hasMetadata(META_KEY)) {
                    Fabled.removeMeta((Metadatable)target, META_KEY);
                }
            }, (long)newTicks);
        });
        return targets.size() > 0;
    }
}

