/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.enums.ExpSource;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;
import studio.magemonkey.fabled.listener.MechanicListener;

public class ExperienceMechanic
extends MechanicComponent {
    private static final String TYPE = "type";
    private static final String GROUP = "group";
    private static final String EXP = "value";
    private static final String LEVEL_DOWN = "level-down";
    private static final String MODE = "mode";

    @Override
    public String getKey() {
        return "experience";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (!(caster instanceof Player)) {
            return false;
        }
        Player player = (Player)caster;
        String group = this.settings.getString(GROUP, "class");
        if (Fabled.getGroups().stream().noneMatch(c -> c.equalsIgnoreCase(group))) {
            return false;
        }
        int expValue = this.settings.getInt(EXP, 0);
        boolean levelDown = this.settings.getBool(LEVEL_DOWN, false);
        String mode = this.settings.getString(MODE, "give").toLowerCase();
        String type = this.settings.getString(TYPE, "flat");
        boolean flat = type.equalsIgnoreCase("flat");
        boolean percent = type.equalsIgnoreCase("percent");
        PlayerClass playerClass = Fabled.getData((OfflinePlayer)player).getClass(group);
        double allNextLevelExp = playerClass.getData().getRequiredExp(playerClass.getLevel());
        double amount = 0.0;
        if (flat) {
            amount = expValue;
        } else if (percent) {
            amount = allNextLevelExp * (double)expValue / 100.0;
        }
        switch (mode) {
            case "give": {
                MechanicListener.addExemptExperience(player, amount);
                playerClass.giveExp(amount, ExpSource.PLUGIN);
                break;
            }
            case "take": {
                if (!levelDown && amount > playerClass.getExp()) {
                    return false;
                }
                playerClass.loseExp(amount, false, levelDown);
                break;
            }
            case "set": {
                playerClass.setExp(amount);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

