/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.List;
import java.util.Locale;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageEvent;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class DamageMechanic
extends MechanicComponent {
    private static final String TYPE = "type";
    private static final String DAMAGE = "value";
    private static final String TRUE = "true";
    private static final String CLASSIFIER = "classifier";
    private static final String KNOCKBACK = "knockback";
    private static final String CAUSE = "cause";

    @Override
    public String getKey() {
        return "damage";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        String pString = this.settings.getString(TYPE, "damage").toLowerCase();
        boolean percent = pString.equals("multiplier") || pString.equals("percent");
        boolean missing = pString.equals("percent missing");
        boolean left = pString.equals("percent left");
        boolean trueDmg = this.settings.getBool(TRUE, false);
        double damage = this.parseValues(caster, DAMAGE, level, 1.0);
        boolean knockback = this.settings.getBool(KNOCKBACK, true);
        String classification = this.settings.getString(CLASSIFIER, "default");
        if (damage < 0.0) {
            return false;
        }
        for (LivingEntity target : targets) {
            if (target.isDead()) continue;
            double amount = damage;
            if (percent) {
                amount = damage * target.getMaxHealth() / 100.0;
            } else if (missing) {
                amount = damage * (target.getMaxHealth() - target.getHealth()) / 100.0;
            } else if (left) {
                amount = damage * target.getHealth() / 100.0;
            }
            if (trueDmg) {
                this.skill.trueDamage(target, amount, caster);
                continue;
            }
            this.skill.damage(target, amount, caster, classification, knockback, EntityDamageEvent.DamageCause.valueOf((String)this.settings.getString(CAUSE, "Entity Attack").toUpperCase(Locale.US).replace(' ', '_')));
        }
        return targets.size() > 0;
    }
}

