/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.List;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.api.util.Buff;
import studio.magemonkey.fabled.api.util.BuffManager;
import studio.magemonkey.fabled.api.util.BuffType;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class BuffMechanic
extends MechanicComponent {
    private static final String MODIFIER = "modifier";
    private static final String CATEGORY = "category";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String SECONDS = "seconds";
    private static final String IMMEDIATE = "immediate";

    @Override
    public String getKey() {
        return "buff";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0) {
            return false;
        }
        boolean immediate = this.settings.getString(IMMEDIATE, "false").equalsIgnoreCase("true");
        double value = this.parseValues(caster, VALUE, level, 1.0);
        boolean percent = this.settings.getString(MODIFIER, "flat").equalsIgnoreCase("multiplier");
        if (immediate) {
            this.skill.setImmediateBuff(value, !percent);
            return true;
        }
        BuffType buffType = BuffType.valueOf(this.settings.getString(TYPE, "DAMAGE"));
        double seconds = this.parseValues(caster, SECONDS, level, 3.0);
        String category = this.settings.getString(CATEGORY, null);
        int ticks = (int)(seconds * 20.0);
        for (LivingEntity target : targets) {
            BuffManager.getBuffData(target).addBuff(buffType, category, new Buff(this.skill.getName() + "-" + caster.getName(), value, percent), ticks);
        }
        return targets.size() > 0;
    }
}

