/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.condition;

import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.condition.ConditionComponent;

public class WorldCondition
extends ConditionComponent {
    private static final String WORLDS = "worlds";
    private static final String BLACKLIST = "blacklist";
    private Set<String> worlds;
    private boolean blacklist;

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        return this.worlds.contains(caster.getWorld().getName()) != this.blacklist;
    }

    @Override
    public void load(DynamicSkill skill, DataSection config) {
        super.load(skill, config);
        this.blacklist = this.settings.getString(BLACKLIST).equalsIgnoreCase("True");
        this.worlds = this.settings.getStringList(WORLDS).stream().collect(Collectors.toSet());
    }

    @Override
    public String getKey() {
        return "World";
    }
}

