/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.condition;

import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.condition.ConditionComponent;

public class BiomeCondition
extends ConditionComponent {
    private static final String TYPE = "type";
    private static final String BIOME = "biome";
    private Set<String> biomes;
    private boolean requiresIn;

    @Override
    public String getKey() {
        return BIOME;
    }

    @Override
    public void load(DynamicSkill skill, DataSection config) {
        super.load(skill, config);
        this.requiresIn = !this.settings.getString(TYPE, "in biome").toLowerCase().equals("not in biome");
        this.biomes = this.settings.getStringList(BIOME).stream().map(s -> s.toUpperCase(Locale.US).replace(' ', '_')).collect(Collectors.toSet());
    }

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        return this.biomes.contains(target.getLocation().getBlock().getBiome().name()) == this.requiresIn;
    }
}

