/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.enums.ManaCost;
import studio.magemonkey.fabled.api.event.DynamicTriggerEvent;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.dynamic.ComponentRegistry;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.EffectComponent;
import studio.magemonkey.fabled.dynamic.trigger.ChatTrigger;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;
import studio.magemonkey.fabled.dynamic.trigger.TriggerComponent;

public class TriggerHandler
implements Listener {
    private final Map<Integer, Integer> active = new HashMap<Integer, Integer>();
    private final DynamicSkill skill;
    private final String key;
    private final Trigger<?> trigger;
    private final TriggerComponent component;

    public TriggerHandler(DynamicSkill skill, String key, Trigger<?> trigger, TriggerComponent component) {
        Objects.requireNonNull(skill, "Must provide a skill");
        Objects.requireNonNull(key, "Must provide a key");
        Objects.requireNonNull(trigger, "Must provide a trigger");
        Objects.requireNonNull(component, "Must provide a component");
        this.skill = skill;
        this.key = key;
        this.trigger = trigger;
        this.component = component;
    }

    public EffectComponent getComponent() {
        return this.component;
    }

    public void init(LivingEntity entity, int level) {
        this.active.put(entity.getEntityId(), level);
    }

    public void cleanup(LivingEntity entity) {
        this.active.remove(entity.getEntityId());
        this.component.cleanUp(entity);
    }

    public void register(Fabled plugin) {
        plugin.getServer().getPluginManager().registerEvent(this.trigger.getEvent(), (Listener)this, EventPriority.HIGHEST, ComponentRegistry.getExecutor(this.trigger), (Plugin)plugin, !this.trigger.getEvent().getTypeName().equals("org.bukkit.event.player.PlayerInteractEvent") && !this.trigger.getEvent().getTypeName().contains("PlayerSwapHandItemsEvent"));
    }

    <T extends Event> void apply(T event, Trigger<T> trigger) {
        LivingEntity caster = trigger.getCaster(event);
        if (caster == null || !this.active.containsKey(caster.getEntityId())) {
            return;
        }
        int level = this.active.get(caster.getEntityId());
        if (!trigger.shouldTrigger(event, level, this.component.settings)) {
            return;
        }
        if (trigger instanceof ChatTrigger) {
            Bukkit.getScheduler().runTask((Plugin)Fabled.inst(), () -> {
                Bukkit.getPluginManager().callEvent((Event)new DynamicTriggerEvent(caster, this.skill, event, trigger.getKey()));
                LivingEntity target = trigger.getTarget(event, this.component.settings);
                trigger.setValues(event, DynamicSkill.getCastData(caster));
                this.trigger(caster, target, level);
                trigger.postProcess(event, this.skill);
            });
        } else {
            Bukkit.getPluginManager().callEvent((Event)new DynamicTriggerEvent(caster, this.skill, event, trigger.getKey()));
            LivingEntity target = trigger.getTarget(event, this.component.settings);
            trigger.setValues(event, DynamicSkill.getCastData(caster));
            this.trigger(caster, target, level);
            if (event instanceof Cancellable) {
                this.skill.applyCancelled((Cancellable)event);
            }
            trigger.postProcess(event, this.skill);
        }
    }

    boolean trigger(LivingEntity user, LivingEntity target, int level) {
        if (user == null || target == null || this.component.isRunning() || !Fabled.getSettings().isValidTarget(target)) {
            return false;
        }
        if (user instanceof Player) {
            PlayerData data = Fabled.getData((OfflinePlayer)((Player)user));
            PlayerSkill skill = data.getSkill(this.skill.getName());
            boolean cd = this.component.getSettings().getBool("cooldown", false);
            boolean mana = this.component.getSettings().getBool("mana", false);
            if ((cd || mana) && !data.check(skill, cd, mana)) {
                return false;
            }
            if (this.component.trigger(user, target, level, false)) {
                if (cd) {
                    skill.startCooldown();
                }
                if (mana) {
                    data.useMana(skill.getManaCost(), ManaCost.SKILL_CAST);
                }
                return true;
            }
            return false;
        }
        return this.component.trigger(user, target, level, false);
    }

    public String getKey() {
        return this.key;
    }

    public Trigger<?> getTrigger() {
        return this.trigger;
    }
}

