/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import studio.magemonkey.codex.mccore.config.parse.NumberParser;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.EffectComponent;

public class ItemChecker {
    private static final String CHECK_MAT = "check-mat";
    private static final String MATERIAL = "material";
    private static final String CHECK_DATA = "check-data";
    private static final String DATA = "data";
    private static final String CHECK_CUSTOM_DATA = "check-custom-data";
    private static final String CUSTOM_DATA = "custom-data";
    private static final String CHECK_LORE = "check-lore";
    private static final String LORE = "lore";
    private static final String REGEX = "regex";
    private static final String CHECK_NAME = "check-name";
    private static final String NAME = "name";
    private static final String AMOUNT = "amount";

    public static boolean check(Player player, int level, EffectComponent component, boolean remove) {
        Settings settings = component.getSettings();
        int count = (int)component.parseValues((LivingEntity)player, AMOUNT, level, 1.0);
        boolean mat = settings.getBool(CHECK_MAT, true);
        boolean data = settings.getBool(CHECK_DATA, true);
        boolean checkCustom = settings.getBool(CHECK_CUSTOM_DATA, false);
        boolean lore = settings.getBool(CHECK_LORE, false);
        boolean name = settings.getBool(CHECK_NAME, false);
        boolean regex = settings.getBool(REGEX, false);
        String material = settings.getString(MATERIAL, "ARROW").toUpperCase(Locale.US).replace(" ", "_");
        int dur = settings.getInt(DATA, 0);
        int customData = settings.getInt(CUSTOM_DATA, 0);
        String text = settings.getString(LORE, "");
        String display = settings.getString(NAME, "");
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack item = contents[i];
            if (item == null || mat && !item.getType().name().equals(material) || data && item.getData().getData() != dur || checkCustom && (!item.hasItemMeta() || item.getItemMeta().hasCustomModelData() || item.getItemMeta().getCustomModelData() != customData) || lore && !ItemChecker.checkLore(item, text, regex) || name && !ItemChecker.checkName(item, display, regex)) continue;
            if (item.getAmount() <= count) {
                count -= item.getAmount();
                if (remove) {
                    contents[i] = null;
                }
            } else {
                if (remove) {
                    item.setAmount(item.getAmount() - count);
                }
                count = 0;
            }
            if (count == 0) break;
        }
        if (remove) {
            player.getInventory().setContents(contents);
        }
        return count == 0;
    }

    public static boolean check(ItemStack item, int level, Settings settings) {
        boolean mat = settings.getBool(CHECK_MAT, true);
        boolean data = settings.getBool(CHECK_DATA, true);
        boolean checkCustom = settings.getBool(CHECK_CUSTOM_DATA, false);
        boolean lore = settings.getBool(CHECK_LORE, false);
        boolean name = settings.getBool(CHECK_NAME, false);
        boolean regex = settings.getBool(REGEX, false);
        String material = settings.getString(MATERIAL, "ARROW").toUpperCase(Locale.US).replace(" ", "_");
        boolean anyMaterial = material.equals("ANY");
        String potion = settings.getString("potion", "Any").toUpperCase(Locale.US).replace(" ", "_");
        boolean anyPotion = potion.equals("ANY");
        int dur = settings.getInt(DATA, 0);
        int customData = settings.getInt(CUSTOM_DATA, 0);
        String text = settings.getString(LORE, "");
        String display = settings.getString(NAME, "");
        ArrayList<String> potionTypes = new ArrayList<String>();
        if (item != null && item.hasItemMeta() && item.getItemMeta() instanceof PotionMeta) {
            PotionType pType = ((PotionMeta)item.getItemMeta()).getBasePotionType();
            for (PotionEffect potionEffect : pType.getPotionEffects()) {
                potionTypes.add(potionEffect.getType().getName());
            }
        }
        return !((item != null || !material.equals("AIR")) && (item == null || mat && !anyMaterial && !item.getType().name().equals(material) || material.contains("POTION") && !anyPotion && !potionTypes.contains(potion) || data && item.getDurability() != dur || checkCustom && (!item.hasItemMeta() || !item.getItemMeta().hasCustomModelData() || item.getItemMeta().getCustomModelData() != customData) || lore && !ItemChecker.checkLore(item, text, regex) || name && !ItemChecker.checkName(item, display, regex)));
    }

    public static boolean checkName(ItemStack item, String target, boolean regex) {
        ItemMeta meta;
        if (!item.hasItemMeta() || !(meta = item.getItemMeta()).hasDisplayName()) {
            return false;
        }
        String name = ChatColor.stripColor((String)meta.getDisplayName());
        if (regex && Pattern.compile(target).matcher(name).find()) {
            return true;
        }
        return !regex && name.contains(target);
    }

    public static boolean checkLore(ItemStack item, String target, boolean regex) {
        ItemMeta meta;
        if (!item.hasItemMeta() || !(meta = item.getItemMeta()).hasLore()) {
            return false;
        }
        List lore = meta.getLore();
        for (String line : lore) {
            line = ChatColor.stripColor((String)line);
            if (regex && Pattern.compile(target).matcher(line).find()) {
                return true;
            }
            if (regex || !line.contains(target)) continue;
            return true;
        }
        return false;
    }

    public static boolean findLore(LivingEntity caster, ItemStack item, String regex, String key, double multiplier, boolean save) {
        Pattern pattern = Pattern.compile(regex.replace("{value}", "([+-]?[0-9]+([.,][0-9]+)?)"));
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return false;
        }
        List lore = item.getItemMeta().getLore();
        for (String line : lore) {
            Matcher matcher = pattern.matcher(line = ChatColor.stripColor((String)line));
            if (!matcher.find()) continue;
            String value = matcher.group(1);
            try {
                double base = NumberParser.parseDouble((String)value);
                DynamicSkill.getCastData(caster).put(key, base * multiplier);
                if (!save) break;
                Fabled.getData((OfflinePlayer)caster).setPersistentData(key, DynamicSkill.getCastData(caster).getRaw(key));
                break;
            }
            catch (Exception exception) {
            }
        }
        return true;
    }
}

