/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.dynamic.ComponentRegistry;
import studio.magemonkey.fabled.dynamic.ComponentType;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.log.Logger;

public abstract class EffectComponent {
    private static final String ICON_KEY = "icon-key";
    private static final String COUNTS_KEY = "counts";
    private static final String TYPE = "type";
    private static final String PREVIEW = "preview";
    private static boolean passed;
    public final ArrayList<EffectComponent> children = new ArrayList();
    protected final Settings settings = new Settings();
    private boolean isPreviewEnabled = false;
    protected final Settings preview = new Settings();
    protected DynamicSkill skill;
    private String instanceKey;

    private static String filterSpecialChars(String string) {
        int i = 0;
        int j = string.indexOf(38);
        StringBuilder builder = new StringBuilder();
        while (j >= 0) {
            String key;
            switch (key = string.substring(j + 1, j + 3)) {
                case "rc": {
                    builder.append(string, i, j);
                    builder.append('}');
                    i = j + 3;
                    break;
                }
                case "lc": {
                    builder.append(string, i, j);
                    builder.append('{');
                    i = j + 3;
                    break;
                }
                case "sq": {
                    builder.append(string, i, j);
                    builder.append('\'');
                    i = j + 3;
                    break;
                }
                default: {
                    ++i;
                }
            }
            j = string.indexOf(38, i);
        }
        builder.append(string.substring(i));
        return builder.toString();
    }

    public String getInstanceKey() {
        return this.instanceKey;
    }

    public abstract String getKey();

    public abstract ComponentType getType();

    public Settings getSettings() {
        return this.settings;
    }

    public boolean isPreviewEnabled() {
        return this.isPreviewEnabled;
    }

    protected double parseValues(LivingEntity caster, String key, int level, double fallback) {
        double base = this.getNum(caster, key + "-base", fallback);
        double scale = this.getNum(caster, key + "-scale", 0.0);
        double value = base + (double)(level - 1) * scale;
        if (Fabled.getSettings().isAttributesEnabled() && caster instanceof Player) {
            PlayerData data = Fabled.getData((OfflinePlayer)((Player)caster));
            value = data.scaleDynamic(this, key, value);
        }
        return value;
    }

    protected double getNum(LivingEntity caster, String key, double fallback) {
        String val = this.settings.getString(key);
        if (val == null) {
            return fallback;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (Exception exception) {
            CastData castData = DynamicSkill.getCastData(caster);
            if (castData.contains(val)) {
                String mapVal = castData.get(val);
                try {
                    return Double.parseDouble(mapVal);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            try {
                int mid = val.indexOf(45, 1);
                double min = Double.parseDouble(val.substring(0, mid));
                double max = Double.parseDouble(val.substring(mid + 1));
                return Math.random() * (max - min) + min;
            }
            catch (Exception exception3) {
                return 0.0;
            }
        }
    }

    protected boolean lastPassed() {
        return passed;
    }

    protected boolean executeChildren(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        boolean worked = false;
        for (EffectComponent child : this.children) {
            boolean counts = !child.settings.getString(COUNTS_KEY, "true").equalsIgnoreCase("false");
            passed = child.execute(caster, level, targets, force);
            worked = passed && counts || worked;
        }
        return worked;
    }

    public void cleanUp(LivingEntity caster) {
        this.doCleanUp(caster);
        this.children.forEach(child -> child.cleanUp(caster));
    }

    protected void doCleanUp(LivingEntity caster) {
    }

    protected PlayerSkill getSkillData(LivingEntity caster) {
        if (caster instanceof Player) {
            return Fabled.getData((OfflinePlayer)((Player)caster)).getSkill(this.skill.getName());
        }
        return null;
    }

    protected String filter(LivingEntity caster, LivingEntity target, String text) {
        int i = text.indexOf(123);
        if (i < 0) {
            return EffectComponent.filterSpecialChars(text);
        }
        int j = text.indexOf(125, i);
        if (j < 0) {
            return EffectComponent.filterSpecialChars(text);
        }
        StringBuilder builder = new StringBuilder();
        CastData data = DynamicSkill.getCastData(caster);
        int k = 0;
        while (i >= 0 && j > i) {
            String key = text.substring(i + 1, j);
            if (data.contains(key)) {
                String obj = data.get(key);
                builder.append(text, k, i);
                builder.append(obj);
                k = j + 1;
            } else if (key.equals("player")) {
                builder.append(text, k, i);
                builder.append(caster.getName());
                k = j + 1;
            } else if (key.equals("target")) {
                builder.append(text, k, i);
                builder.append(target.getName());
                k = j + 1;
            } else if (key.equals("targetUUID")) {
                builder.append(text, k, i);
                builder.append(target.getUniqueId());
                k = j + 1;
            }
            i = text.indexOf(123, j);
            j = text.indexOf(125, i);
        }
        builder.append(text.substring(k));
        return EffectComponent.filterSpecialChars(builder.toString());
    }

    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets) {
        return this.execute(caster, level, targets, false);
    }

    public abstract boolean execute(LivingEntity var1, int var2, List<LivingEntity> var3, boolean var4);

    public void playPreview(List<Runnable> onPreviewStop, final Player caster, int level, final Supplier<List<LivingEntity>> targetSupplier) {
        if (this.preview.getBool("per-target")) {
            BukkitTask task = new BukkitRunnable(){

                public void run() {
                    for (LivingEntity target : (List)targetSupplier.get()) {
                        ParticleHelper.play(target.getLocation(), EffectComponent.this.preview, Set.of(caster), "per-target-", EffectComponent.this.preview.getBool("per-target-hitbox") ? target.getBoundingBox() : null);
                    }
                }
            }.runTaskTimer((Plugin)Fabled.inst(), 0L, (long)Math.max(1, this.preview.getInt("per-target-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
        this.playChildrenPreviews(onPreviewStop, caster, level, targetSupplier);
    }

    public void playChildrenPreviews(List<Runnable> onPreviewStop, Player caster, int level, Supplier<List<LivingEntity>> targetSupplier) {
        for (EffectComponent child : this.children) {
            child.playPreview(onPreviewStop, caster, level, targetSupplier);
        }
    }

    public void save(DataSection config) {
        config.set(TYPE, (Object)this.getType().name().toLowerCase());
        this.settings.save(config.createSection("data"));
        this.preview.save(config.createSection(PREVIEW));
        DataSection children = config.createSection("children");
        for (EffectComponent child : this.children) {
            child.save(children.createSection(child.instanceKey));
        }
    }

    public void load(DynamicSkill skill, DataSection config) {
        String key;
        this.skill = skill;
        if (config == null) {
            return;
        }
        this.settings.load(config.getSection("data"));
        if (this.settings.has(ICON_KEY) && !(key = this.settings.getString(ICON_KEY)).equals("")) {
            skill.setAttribKey(key, this);
        }
        this.preview.load(config.getSection(PREVIEW));
        this.isPreviewEnabled = this.preview.getBool("enabled", false);
        DataSection children = config.getSection("children");
        if (children != null) {
            for (String key2 : children.keys()) {
                String typeName = children.getSection(key2).getString(TYPE, "missing").toUpperCase(Locale.US);
                ComponentType type = ComponentType.valueOf(typeName);
                String mkey = key2.replaceAll("-.+", "");
                try {
                    EffectComponent child = ComponentRegistry.getComponent(type, mkey);
                    if (child != null) {
                        child.instanceKey = key2;
                        child.load(skill, children.getSection(key2));
                        this.children.add(child);
                        continue;
                    }
                    Logger.invalid("Invalid " + type + " component: " + mkey);
                }
                catch (Exception ex) {
                    Logger.bug("Failed to create " + type + " component: " + key2);
                }
            }
        }
    }
}

