/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.data.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.codex.mccore.config.parse.YAMLParser;
import studio.magemonkey.codex.mccore.sql.ColumnType;
import studio.magemonkey.codex.mccore.sql.direct.SQLDatabase;
import studio.magemonkey.codex.mccore.sql.direct.SQLTable;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerAccounts;
import studio.magemonkey.fabled.data.Settings;
import studio.magemonkey.fabled.data.io.IOManager;
import studio.magemonkey.fabled.log.Logger;

public class SQLIO
extends IOManager {
    public static final String ID = "id";
    public static final String DATA = "data";

    public SQLIO(Fabled api) {
        super(api);
    }

    private SQLConnection openConnection() {
        SQLConnection connection = new SQLConnection();
        Settings settings = Fabled.getSettings();
        connection.database = new SQLDatabase((Plugin)this.api, settings.getSqlHost(), settings.getSqlPort(), settings.getSqlDatabase(), settings.getSqlUser(), settings.getSqlPass());
        connection.database.openConnection();
        connection.table = connection.database.createTable((Plugin)this.api, "players");
        connection.table.createColumn(ID, ColumnType.INCREMENT);
        connection.table.createColumn(DATA, ColumnType.MEDIUM_TEXT);
        return connection;
    }

    @Override
    public Map<String, PlayerAccounts> loadAll() {
        SQLConnection connection = this.openConnection();
        HashMap<String, PlayerAccounts> result = new HashMap<String, PlayerAccounts>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            result.put(player.getUniqueId().toString().toLowerCase(), this.load(connection, (OfflinePlayer)player));
        }
        connection.database.closeConnection();
        return result;
    }

    @Override
    public PlayerAccounts loadData(OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        SQLConnection connection = this.openConnection();
        PlayerAccounts result = this.load(connection, player);
        connection.database.closeConnection();
        return result;
    }

    @Override
    public void saveData(PlayerAccounts data) {
        if (!data.isLoaded()) {
            return;
        }
        SQLConnection connection = this.openConnection();
        this.saveSingle(connection, data);
        connection.database.closeConnection();
    }

    @Override
    public void saveAll() {
        SQLConnection connection = this.openConnection();
        Map<String, PlayerAccounts> data = Fabled.getPlayerAccounts();
        ArrayList<String> keys = new ArrayList<String>(data.keySet());
        for (String key : keys) {
            this.saveSingle(connection, data.get(key));
        }
        connection.database.closeConnection();
    }

    private PlayerAccounts load(SQLConnection connection, OfflinePlayer player) {
        try {
            String playerKey = player.getUniqueId().toString().toLowerCase();
            DataSection file = new YAMLParser().parseText(connection.table.createEntry(playerKey).getString(DATA));
            return this.load(player, file);
        }
        catch (Exception ex) {
            Logger.bug("Failed to load data from the SQL Database - " + ex.getMessage());
            return null;
        }
    }

    private void saveSingle(SQLConnection connection, PlayerAccounts data) {
        DataSection file = this.save(data);
        try {
            String playerKey = data.getOfflinePlayer().getUniqueId().toString().toLowerCase();
            connection.table.createEntry(playerKey).set(DATA, file.toString());
        }
        catch (Exception ex) {
            Logger.bug("Failed to save data for invalid player");
        }
    }

    private class SQLConnection {
        private SQLDatabase database;
        private SQLTable table;

        private SQLConnection() {
        }
    }
}

