/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.data.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.mccore.config.CommentedConfig;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerAccounts;
import studio.magemonkey.fabled.data.io.IOManager;
import studio.magemonkey.fabled.log.Logger;

public class ConfigIO
extends IOManager {
    public ConfigIO(Fabled plugin) {
        super(plugin);
    }

    @Override
    public Map<String, PlayerAccounts> loadAll() {
        HashMap<String, PlayerAccounts> result = new HashMap<String, PlayerAccounts>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            result.put(player.getUniqueId().toString().toLowerCase(), this.loadData((OfflinePlayer)player));
        }
        return result;
    }

    @Override
    public PlayerAccounts loadData(OfflinePlayer player) {
        String playerKey = player.getUniqueId().toString().toLowerCase();
        CommentedConfig config = new CommentedConfig((JavaPlugin)this.api, "players/" + playerKey);
        CommentedConfig nameConfig = new CommentedConfig((JavaPlugin)this.api, "players/" + player.getName());
        if (!playerKey.equals(player.getName()) && nameConfig.getConfigFile().exists()) {
            DataSection old = nameConfig.getConfig();
            for (String key : old.keys()) {
                config.getConfig().set(key, old.get(key));
            }
            nameConfig.getConfigFile().delete();
        }
        DataSection file = config.getConfig();
        return this.load(player, file);
    }

    @Override
    public void saveData(PlayerAccounts data) {
        if (!data.isLoaded()) {
            return;
        }
        try {
            CommentedConfig config = new CommentedConfig((JavaPlugin)this.api, "players/" + data.getOfflinePlayer().getUniqueId().toString().toLowerCase());
            config.clear();
            DataSection file = this.save(data);
            config.getConfig().applyDefaults(file);
            config.save();
        }
        catch (Exception ex) {
            Logger.bug("Failed to save data for invalid player");
        }
    }

    @Override
    public void saveAll() {
        Map<String, PlayerAccounts> data = Fabled.getPlayerAccounts();
        ArrayList<String> keys = new ArrayList<String>(data.keySet());
        for (String key : keys) {
            this.saveData(data.get(key));
        }
    }
}

