/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.data;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import studio.magemonkey.codex.mccore.config.parse.NumberParser;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.enums.Operation;
import studio.magemonkey.fabled.api.player.PlayerAttributeModifier;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.data.Settings;

public class PlayerEquips {
    private final PlayerData playerData;
    private final EquipData emptyEquip = new EquipData();
    private final HashMap<Integer, EquipData> equips = new HashMap();
    private EquipData handHeldItem = new EquipData();

    public PlayerEquips(PlayerData player) {
        this.playerData = player;
        for (int slot : Fabled.getSettings().getSlots()) {
            this.equips.put(slot, this.emptyEquip);
        }
    }

    public boolean canHit() {
        return this.handHeldItem.hasMetConditions();
    }

    public boolean canBlock() {
        return this.equips.get(40).hasMetConditions();
    }

    public boolean update(Player player) {
        boolean isChanged = false;
        this.updateHandHeldItem(player, player.getInventory().getItemInMainHand());
        for (Map.Entry<Integer, EquipData> entry : this.equips.entrySet()) {
            int slot = entry.getKey();
            if (!this.updateEquip(player, slot, player.getInventory().getItem(slot))) continue;
            isChanged = true;
        }
        return isChanged;
    }

    public boolean updateHandHeldItem(Player player, ItemStack item) {
        EquipData from = this.handHeldItem;
        if (Objects.equal((Object)from.item, (Object)item)) {
            return false;
        }
        from.revert();
        EquipData to = item == null ? this.emptyEquip : new EquipData(item, EquipType.HAND_HELD_ITEM);
        if (!to.hasMetConditions()) {
            if (Fabled.getSettings().isDropWeapon()) {
                player.getInventory().removeItem(new ItemStack[]{to.item});
                player.updateInventory();
                player.getWorld().dropItemNaturally(player.getLocation(), to.item);
                return false;
            }
            this.handHeldItem = to;
        } else {
            this.handHeldItem = to;
            to.apply();
        }
        return true;
    }

    public boolean updateEquip(Player player, int slot, ItemStack item) {
        EquipData from = this.equips.get(slot);
        if (Objects.equal((Object)from.item, (Object)item)) {
            return false;
        }
        from.revert();
        EquipData to = item == null || slot == player.getInventory().getHeldItemSlot() ? this.emptyEquip : new EquipData(item, EquipType.fromSlot(slot));
        if (!to.hasMetConditions()) {
            if (Fabled.getSettings().isDropWeapon()) {
                player.getInventory().setItem(slot, null);
                player.updateInventory();
                player.getWorld().dropItemNaturally(player.getLocation(), to.item);
                return false;
            }
        } else {
            this.equips.put(slot, to);
            to.apply();
        }
        return true;
    }

    public EquipData getEquipData(ItemStack item, EquipType type) {
        return new EquipData(item, type);
    }

    public class EquipData {
        private final List<UUID> attrModifierUUIDs = new ArrayList<UUID>();
        private HashMap<String, Integer> skillReq;
        private HashMap<String, Integer> attrReq;
        private HashMap<String, Integer> attribs;
        private HashSet<String> classReq;
        private HashSet<String> classExc;
        private ItemStack item;
        private int levelReq;
        private EquipType type;

        public EquipData() {
        }

        public EquipData(ItemStack item, EquipType type) {
            this.item = item;
            this.type = type;
            if (!item.hasItemMeta()) {
                return;
            }
            ItemMeta itemMeta = item.getItemMeta();
            if (itemMeta == null) {
                return;
            }
            if (!itemMeta.hasLore()) {
                return;
            }
            List lore = itemMeta.getLore();
            Settings settings = Fabled.getSettings();
            String classText = settings.getLoreClassText();
            String excludeText = settings.getLoreExcludeText();
            String levelText = settings.getLoreLevelText();
            boolean skills = settings.isCheckSkills();
            boolean attributes = settings.isAttributesEnabled();
            block0: for (String line : lore) {
                String text;
                String lower = ChatColor.stripColor((String)line).toLowerCase();
                if (lower.startsWith(levelText)) {
                    this.levelReq = NumberParser.parseInt((String)lower.substring(levelText.length()));
                    continue;
                }
                if (lower.startsWith(classText)) {
                    List<String> required = Arrays.asList(lower.substring(classText.length()).split(", "));
                    if (this.classReq == null) {
                        this.classReq = new HashSet();
                    }
                    this.classReq.addAll(required);
                    continue;
                }
                if (lower.startsWith(excludeText)) {
                    List<String> excluded = Arrays.asList(lower.substring(excludeText.length()).split(", "));
                    if (this.classExc == null) {
                        this.classExc = new HashSet();
                    }
                    this.classExc.addAll(excluded);
                    continue;
                }
                boolean done = false;
                if (skills) {
                    for (Skill skill : Fabled.getSkills().values()) {
                        text = settings.getSkillText(skill.getName());
                        if (!lower.startsWith(text)) continue;
                        done = true;
                        if (this.skillReq == null) {
                            this.skillReq = new HashMap();
                        }
                        this.skillReq.put(skill.getName(), NumberParser.parseInt((String)lower.substring(text.length())));
                        break;
                    }
                }
                if (!attributes || done) continue;
                for (String attr : Fabled.getAttributeManager().getLookupKeys()) {
                    String normalized;
                    text = settings.getAttrReqText(attr);
                    if (lower.startsWith(text)) {
                        if (this.attrReq == null) {
                            this.attrReq = new HashMap();
                        }
                        normalized = Fabled.getAttributeManager().normalize(attr);
                        this.attrReq.put(normalized, NumberParser.parseInt((String)lower.substring(text.length())));
                        continue block0;
                    }
                    text = settings.getAttrGiveText(attr);
                    if (!lower.startsWith(text)) continue;
                    if (this.attribs == null) {
                        this.attribs = new HashMap();
                    }
                    normalized = Fabled.getAttributeManager().normalize(attr);
                    int current = this.attribs.containsKey(attr) ? this.attribs.get(attr) : 0;
                    int extra = NumberParser.parseInt((String)lower.substring(text.length()).replace("%", ""));
                    this.attribs.put(normalized, current + extra);
                    continue block0;
                }
            }
        }

        private void apply() {
            if (this.attribs != null) {
                for (Map.Entry<String, Integer> entry : this.attribs.entrySet()) {
                    PlayerAttributeModifier attrModifier = new PlayerAttributeModifier("fabled.player_equips", entry.getValue().intValue(), Operation.ADD_NUMBER, false);
                    this.attrModifierUUIDs.add(attrModifier.getUUID());
                    PlayerEquips.this.playerData.addAttributeModifier(entry.getKey(), attrModifier, false);
                }
            }
        }

        private void revert() {
            if (this.attribs != null) {
                for (UUID uuid : this.attrModifierUUIDs) {
                    PlayerEquips.this.playerData.removeAttributeModifier(uuid, false);
                }
            }
        }

        public boolean hasMetConditions() {
            String className;
            if (this.item == null) {
                return true;
            }
            PlayerClass main = PlayerEquips.this.playerData.getMainClass();
            String string = className = main == null ? "null" : main.getData().getName().toLowerCase();
            if (this.levelReq > 0 && (main == null || main.getLevel() < this.levelReq) || this.classExc != null && main != null && this.classExc.contains(className) || this.classReq != null && (main == null || !this.classReq.contains(className))) {
                return false;
            }
            if (this.classExc != null) {
                for (PlayerClass playerClass : PlayerEquips.this.playerData.getClasses()) {
                    if (!this.matches(this.classExc, playerClass)) continue;
                    return false;
                }
            }
            if (this.classReq != null) {
                boolean metClassReq = false;
                for (PlayerClass playerClass : PlayerEquips.this.playerData.getClasses()) {
                    if (!this.matches(this.classReq, playerClass)) continue;
                    metClassReq = true;
                }
                if (!metClassReq) {
                    return false;
                }
            }
            for (PlayerClass playerClass : PlayerEquips.this.playerData.getClasses()) {
                if (playerClass.getData().canUse(this.item.getType())) continue;
                return false;
            }
            if (this.skillReq != null) {
                for (Map.Entry entry : this.skillReq.entrySet()) {
                    if (PlayerEquips.this.playerData.getSkillLevel((String)entry.getKey()) >= (Integer)entry.getValue()) continue;
                    return false;
                }
            }
            if (this.attrReq != null) {
                for (Map.Entry entry : this.attrReq.entrySet()) {
                    if (PlayerEquips.this.playerData.getAttribute((String)entry.getKey()) >= (Integer)entry.getValue()) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean matches(Set<String> names, PlayerClass playerClass) {
            if (playerClass == null) {
                return false;
            }
            for (FabledClass current = playerClass.getData(); current != null; current = current.getParent()) {
                if (!names.contains(current.getName().toLowerCase())) continue;
                return true;
            }
            return false;
        }
    }

    public static enum EquipType {
        HELMET,
        CHESTPLATE,
        LEGGINGS,
        BOOTS,
        HOT_BAR_ITEM,
        HAND_HELD_ITEM,
        OFF_HAND_ITEM,
        INVENTORY_ITEM,
        EXTERNAL_ITEM;


        public static EquipType fromSlot(int slot) {
            switch (slot) {
                case -8: {
                    return HOT_BAR_ITEM;
                }
                case -26: {
                    return INVENTORY_ITEM;
                }
                case 36: {
                    return BOOTS;
                }
                case 37: {
                    return LEGGINGS;
                }
                case 38: {
                    return CHESTPLATE;
                }
                case 39: {
                    return HELMET;
                }
                case 40: {
                    return OFF_HAND_ITEM;
                }
            }
            return EXTERNAL_ITEM;
        }

        public boolean isArmor() {
            switch (this) {
                case HELMET: 
                case CHESTPLATE: 
                case LEGGINGS: 
                case BOOTS: {
                    return true;
                }
            }
            return false;
        }
    }
}

