/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.data;

import java.util.HashMap;
import java.util.Map;
import studio.magemonkey.codex.mccore.util.TextFormatter;
import studio.magemonkey.fabled.Fabled;

public enum Click {
    LEFT(1, "L"),
    RIGHT(2, "R"),
    SHIFT(3, "S"),
    LEFT_SHIFT(4, "LS"),
    RIGHT_SHIFT(5, "RS"),
    SPACE(6, "P"),
    Q(7, "Q"),
    F(8, "F");

    public static final int BITS = 4;
    public static final int BIT_MASK = 15;
    public static final int MAX_COMBO_SIZE = 8;
    private static final Click[] CLICKS;
    private static final Map<String, Click> CLICK_MAP;
    private final int id;
    private final String key;

    private Click(int id, String key) {
        this.id = id;
        this.key = key;
    }

    public static Click getById(int id) {
        if (id < 0 || id >= CLICKS.length) {
            return null;
        }
        return CLICKS[id];
    }

    public static Click getByName(String name) {
        if (name == null) {
            return null;
        }
        name = name.toLowerCase();
        return CLICK_MAP.get(name);
    }

    public int getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return TextFormatter.colorString((String)((String)Fabled.getLanguage().getMessage("Combo." + this.name().toLowerCase()).get(0)));
    }

    static {
        CLICKS = new Click[]{null, LEFT, RIGHT, SHIFT, LEFT_SHIFT, RIGHT_SHIFT, SPACE, Q, F};
        CLICK_MAP = new HashMap<String, Click>(){
            {
                for (Click click : Click.values()) {
                    this.put(click.name().toLowerCase(), click);
                    this.put(click.key.toLowerCase(), click);
                }
            }
        };
    }
}

