/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.util.TextFormatter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.language.RPGFilter;

public class CmdUnbind
implements IFunction {
    private static final String NOT_PLAYER = "not-player";
    private static final String NOT_BOUND = "not-bound";
    private static final String NO_ITEM = "no-item";
    private static final String SKILL_BOUND = "skill-unbound";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand command, Plugin plugin, CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            command.sendMessage(sender, NOT_PLAYER, "&4Only players can use this command", new CustomFilter[0]);
        } else if (!Fabled.getSettings().isWorldEnabled(((Player)sender).getWorld())) {
            command.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", new CustomFilter[0]);
        } else {
            ItemStack item = ((Player)sender).getInventory().getItemInMainHand();
            if (item == null || item.getType() == Material.AIR) {
                command.sendMessage(sender, NO_ITEM, "&4You are not holding an item", new CustomFilter[0]);
                return;
            }
            PlayerData player = Fabled.getData((OfflinePlayer)((Player)sender));
            if (!player.isBound(item.getType())) {
                command.sendMessage(sender, NOT_BOUND, "&4There are no skills bound to the held item", new CustomFilter[0]);
            } else {
                PlayerSkill skill = player.getBoundSkill(item.getType());
                player.clearBind(item.getType());
                command.sendMessage(sender, SKILL_BOUND, "&6{skill} &2has been unbound from &6{item}", new CustomFilter[]{RPGFilter.SKILL.setReplacement(skill.getData().getName()), RPGFilter.ITEM.setReplacement(TextFormatter.format((String)item.getType().name()))});
            }
        }
    }
}

