/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.language.RPGFilter;

public class CmdProfess
implements IFunction,
TabCompleter {
    private static final String CANNOT_USE = "cannot-use";
    private static final String INVALID_CLASS = "invalid-class";
    private static final String PROFESSED = "professed";
    private static final String CANNOT_PROFESS = "cannot-profess";
    private static final String DISABLED = "world-disabled";
    private static final String NOT_AVAILABLE = "not-available";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args) {
        if (sender instanceof Player && !Fabled.getSettings().isWorldEnabled(((Player)sender).getWorld())) {
            cmd.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", new CustomFilter[0]);
        } else if (sender instanceof Player) {
            PlayerData data = Fabled.getData((OfflinePlayer)((Player)sender));
            if (args.length == 0) {
                if (!data.showProfession((Player)sender)) {
                    cmd.sendMessage(sender, NOT_AVAILABLE, ChatColor.RED + "There's no profession available at this time", new CustomFilter[0]);
                }
            } else {
                Object name = args[0];
                for (int i = 1; i < args.length; ++i) {
                    name = (String)name + " " + args[i];
                }
                FabledClass target = Fabled.getClass((String)name);
                if (target == null) {
                    cmd.sendMessage(sender, INVALID_CLASS, ChatColor.RED + "That is not a valid class", new CustomFilter[0]);
                } else if (data.canProfess(target)) {
                    data.profess(target);
                    cmd.sendMessage(sender, PROFESSED, ChatColor.DARK_GREEN + "You are now a " + ChatColor.GOLD + "{class}", new CustomFilter[]{RPGFilter.CLASS.setReplacement(target.getName())});
                } else {
                    cmd.sendMessage(sender, CANNOT_PROFESS, ChatColor.RED + "You cannot profess to this class currently", new CustomFilter[0]);
                }
            }
        } else {
            cmd.sendMessage(sender, CANNOT_USE, ChatColor.RED + "This cannot be used by the console", new CustomFilter[0]);
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender instanceof Player) {
            PlayerData playerData = Fabled.getData((OfflinePlayer)((Player)sender));
            if (playerData == null) {
                return null;
            }
            return ConfigurableCommand.getTabCompletions((Collection)Fabled.getClasses().values().stream().filter(playerData::canProfess).map(FabledClass::getName).collect(Collectors.toList()), (String[])args);
        }
        return null;
    }
}

