/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.Filter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerAccounts;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.api.player.PlayerData;

public class CmdList
implements IFunction,
TabCompleter {
    private static final String NEEDS_ARGS = "needs-player";
    private static final String TITLE = "title";
    private static final String LINE = "line";
    private static final String END = "end";
    private static final String NOT_PLAYER = "not-player";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args) {
        if (sender instanceof Player && !Fabled.getSettings().isWorldEnabled(((Player)sender).getWorld()) && args.length == 0) {
            cmd.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", new CustomFilter[0]);
        } else if (sender instanceof Player || args.length >= 1) {
            OfflinePlayer target;
            OfflinePlayer offlinePlayer = target = args.length == 0 ? (OfflinePlayer)sender : Bukkit.getOfflinePlayer((String)args[0]);
            if (target == null) {
                cmd.sendMessage(sender, NOT_PLAYER, ChatColor.RED + "That is not a valid player name", new CustomFilter[0]);
                return;
            }
            PlayerAccounts accounts = Fabled.getPlayerAccounts(target);
            cmd.sendMessage(sender, TITLE, ChatColor.DARK_GRAY + "--" + ChatColor.DARK_GREEN + " {player} " + ChatColor.DARK_GRAY + "-----------", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName())});
            String line = cmd.getMessage(LINE, ChatColor.GRAY + "[" + ChatColor.GOLD + "{id}" + ChatColor.GRAY + "] " + ChatColor.DARK_GREEN + "Lv" + ChatColor.GOLD + "{level} {class}", new CustomFilter[0]);
            if (accounts != null) {
                for (int i = 1; i <= accounts.getAccountLimit(); ++i) {
                    PlayerData data = accounts.getData(i);
                    PlayerClass cData = data == null ? null : data.getMainClass();
                    Object name = cData == null ? ChatColor.GRAY + "Not Professed" : cData.getData().getPrefix();
                    String level = cData == null ? "0" : "" + cData.getLevel();
                    sender.sendMessage(line.replace("{id}", "" + i).replace("{level}", level).replace("{class}", (CharSequence)name));
                }
            }
            cmd.sendMessage(sender, END, ChatColor.DARK_GRAY + "----------------------------", new CustomFilter[0]);
        } else {
            cmd.sendMessage(sender, NEEDS_ARGS, ChatColor.RED + "A player name is required from the console", new CustomFilter[0]);
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return ConfigurableCommand.getPlayerTabCompletions((CommandSender)commandSender, (String)args[0]);
        }
        return null;
    }
}

