/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.Filter;
import studio.magemonkey.codex.mccore.config.parse.NumberParser;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerAccounts;

public class CmdForceReset
implements IFunction,
TabCompleter {
    private static final String NOT_PLAYER = "not-player";
    private static final String NOT_ACCOUNT = "not-account";
    private static final String RESET = "account-reset";
    private static final String TARGET = "target-notice";

    public void execute(ConfigurableCommand command, Plugin plugin, CommandSender sender, String[] args) {
        if (args.length == 0) {
            command.displayHelp(sender);
        } else {
            OfflinePlayer player = Bukkit.getOfflinePlayer((String)args[0]);
            if (player == null) {
                command.sendMessage(sender, NOT_PLAYER, "&4That is not a valid player name", new CustomFilter[0]);
                return;
            }
            PlayerAccounts accounts = Fabled.getPlayerAccounts(player);
            int id = accounts.getActiveId();
            if (args.length > 1) {
                id = NumberParser.parseInt((String)args[1]);
            }
            if (accounts.getAccountLimit() >= id && id > 0) {
                accounts.setAccount(id);
                accounts.getActiveData().resetAll();
                command.sendMessage(sender, RESET, ChatColor.GOLD + "{player}'s" + ChatColor.DARK_GREEN + " active account has been reset", new CustomFilter[]{Filter.PLAYER.setReplacement(player.getName())});
                if (player.isOnline()) {
                    command.sendMessage((CommandSender)((Player)player), TARGET, ChatColor.DARK_GREEN + "Your class data has been reset", new CustomFilter[0]);
                }
                return;
            }
            command.sendMessage(sender, NOT_ACCOUNT, ChatColor.RED + "That is not a valid account ID", new CustomFilter[0]);
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return ConfigurableCommand.getPlayerTabCompletions((CommandSender)commandSender, (String)args[0]);
        }
        return null;
    }
}

