/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.CommandManager;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.Filter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.data.Click;
import studio.magemonkey.fabled.language.RPGFilter;

public class CmdForceProfess
implements IFunction,
TabCompleter {
    private static final String NOT_PLAYER = "not-player";
    private static final String CANNOT_USE = "cannot-use";
    private static final String INVALID_CLASS = "invalid-class";
    private static final String SUCCESSS = "success";
    private static final String PROFESSED = "professed";
    private static final String CANNOT_PROFESS = "cannot-profess";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args) {
        if (args.length < 2) {
            CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
        } else {
            OfflinePlayer player;
            boolean checkRequirements;
            boolean silent = Arrays.stream(args).anyMatch(s -> s.equalsIgnoreCase("-s"));
            if (silent) {
                args = Arrays.stream(args).filter(s -> !s.equalsIgnoreCase("-s")).collect(Collectors.toList()).toArray(new String[0]);
            }
            boolean bl = checkRequirements = !Arrays.stream(args).anyMatch(s -> s.equalsIgnoreCase("-f"));
            if (!checkRequirements) {
                args = Arrays.stream(args).filter(s -> !s.equalsIgnoreCase("-f")).collect(Collectors.toList()).toArray(new String[0]);
            }
            if ((player = Bukkit.getOfflinePlayer((String)args[0])) == null) {
                cmd.sendMessage(sender, NOT_PLAYER, ChatColor.RED + "That is not a valid player name", new CustomFilter[0]);
                return;
            }
            Object name = args[1];
            for (int i = 2; i < args.length; ++i) {
                name = (String)name + " " + args[i];
            }
            PlayerData data = Fabled.getData(player);
            FabledClass target = Fabled.getClass((String)name);
            if (target == null) {
                cmd.sendMessage(sender, INVALID_CLASS, ChatColor.RED + "That is not a valid class", new CustomFilter[0]);
            } else if (!checkRequirements || data.canProfess(target)) {
                data.profess(target);
                if (player.isOnline()) {
                    cmd.sendMessage(sender, SUCCESSS, ChatColor.GOLD + "{player}" + ChatColor.DARK_GREEN + " is now a " + ChatColor.GOLD + "{class}", new CustomFilter[]{Filter.PLAYER.setReplacement(player.getName()), RPGFilter.CLASS.setReplacement(target.getName())});
                    if (!silent) {
                        cmd.sendMessage((CommandSender)((Player)player), PROFESSED, ChatColor.DARK_GREEN + "You are now a " + ChatColor.GOLD + "{class}", new CustomFilter[]{RPGFilter.CLASS.setReplacement(target.getName())});
                    }
                }
            } else {
                cmd.sendMessage(sender, CANNOT_PROFESS, ChatColor.RED + "They cannot profess to this class currently", new CustomFilter[0]);
            }
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return ConfigurableCommand.getPlayerTabCompletions((CommandSender)commandSender, (String)args[0]);
        }
        if (args.length >= 2) {
            List tabCompletions = ConfigurableCommand.getTabCompletions(Fabled.getClasses().keySet(), (String[])Arrays.copyOfRange(args, 1, args.length));
            if (!tabCompletions.isEmpty()) {
                return tabCompletions;
            }
            ArrayList<String> hyphenArgs = new ArrayList<String>();
            hyphenArgs.add("-s");
            for (int i = 1 + (Click.getByName(args[args.length - 1]) == null ? 1 : 0); args.length > i && hyphenArgs.remove(args[args.length - i]); ++i) {
            }
            return ConfigurableCommand.getTabCompletions(hyphenArgs, (String[])new String[]{args[args.length - 1]});
        }
        return null;
    }
}

