/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.CommandManager;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.Filter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.enums.PointSource;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.cmd.CmdExp;
import studio.magemonkey.fabled.language.RPGFilter;

public class CmdForcePoints
implements IFunction,
TabCompleter {
    private static final String NOT_PLAYER = "not-player";
    private static final String NOT_GROUP = "not-group";
    private static final String NOT_NUMBER = "not-number";
    private static final String GAVE_SP = "gave-points";
    private static final String SET_SP = "set-points";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args) {
        Player target = null;
        Integer amount = null;
        String group = null;
        if (args.length == 2) {
            if (!(sender instanceof Player)) {
                cmd.sendMessage(sender, NOT_PLAYER, ChatColor.RED + "That is not a valid player name", new CustomFilter[0]);
                return;
            }
            target = (Player)sender;
            amount = Integer.parseInt(args[1]);
        } else if (args.length == 3) {
            target = Bukkit.getPlayer((String)args[1]);
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (target == null || amount == null) {
                if (!(sender instanceof Player)) {
                    CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
                    return;
                }
                target = (Player)sender;
                try {
                    amount = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
                    return;
                }
                group = args[2].toLowerCase();
                if (!Fabled.getGroups().contains(group)) {
                    CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
                    return;
                }
            }
        } else if (args.length == 4) {
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                cmd.sendMessage(sender, NOT_PLAYER, ChatColor.RED + "That is not a valid player name", new CustomFilter[0]);
                return;
            }
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException ignored) {
                cmd.sendMessage(sender, NOT_NUMBER, ChatColor.RED + "That is not a valid skill point amount", new CustomFilter[0]);
                return;
            }
            group = args[3].toLowerCase();
            if (!Fabled.getGroups().contains(group)) {
                cmd.sendMessage(sender, NOT_GROUP, ChatColor.RED + "That is not a valid class group", new CustomFilter[0]);
                return;
            }
        }
        if (!Fabled.getSettings().isWorldEnabled(target.getWorld())) {
            cmd.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", new CustomFilter[0]);
            return;
        }
        PlayerData data = Fabled.getData((OfflinePlayer)target);
        if (data == null) {
            cmd.sendMessage(sender, NOT_PLAYER, ChatColor.RED + "That is not a valid player name", new CustomFilter[0]);
            return;
        }
        switch (args[0].toLowerCase()) {
            case "add": {
                if (group == null) {
                    data.givePoints((int)amount, PointSource.COMMAND);
                    cmd.sendMessage(sender, GAVE_SP, ChatColor.DARK_GREEN + "You have given " + ChatColor.GOLD + "{player} {points}{group} " + ChatColor.DARK_GREEN + "skill points", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.GROUP.setReplacement(""), RPGFilter.POINTS.setReplacement("" + amount)});
                    break;
                }
                PlayerClass clazz = data.getClass(group);
                if (clazz == null) {
                    cmd.sendMessage(sender, NOT_GROUP, ChatColor.RED + "That is not a valid class group", new CustomFilter[0]);
                    break;
                }
                clazz.givePoints(amount, PointSource.COMMAND);
                cmd.sendMessage(sender, GAVE_SP, ChatColor.DARK_GREEN + "You have given " + ChatColor.GOLD + "{player} {points}{group} " + ChatColor.DARK_GREEN + "skill points", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.GROUP.setReplacement(" " + group), RPGFilter.POINTS.setReplacement("" + amount)});
                break;
            }
            case "set": {
                if (group == null) {
                    data.setPoints(amount);
                    cmd.sendMessage(sender, SET_SP, ChatColor.DARK_GREEN + "You have set " + ChatColor.GOLD + "{player}'s{group} " + ChatColor.DARK_GREEN + "skill points to " + ChatColor.GOLD + "{points}", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.GROUP.setReplacement(""), RPGFilter.POINTS.setReplacement("" + amount)});
                    break;
                }
                PlayerClass clazz = data.getClass(group);
                if (clazz == null) {
                    cmd.sendMessage(sender, NOT_GROUP, ChatColor.RED + "That is not a valid class group", new CustomFilter[0]);
                    break;
                }
                clazz.setPoints(amount);
                cmd.sendMessage(sender, SET_SP, ChatColor.DARK_GREEN + "You have set " + ChatColor.GOLD + "{player}'s{group} " + ChatColor.DARK_GREEN + "skill points to " + ChatColor.GOLD + "{points}", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.GROUP.setReplacement(" " + group), RPGFilter.POINTS.setReplacement("" + amount)});
                break;
            }
            default: {
                CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
            }
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return ConfigurableCommand.getTabCompletions(List.of("add", "set"), (String[])new String[]{args[0]});
        }
        if (args.length == 2) {
            return ConfigurableCommand.getPlayerTabCompletions((CommandSender)commandSender, (String)args[1]);
        }
        if (args.length > 2 && !args[2].isBlank()) {
            int i;
            int n = i = CmdExp.IS_NUMBER.matcher(args[2]).matches() ? 3 : 2;
            if (i >= args.length) {
                return null;
            }
            return ConfigurableCommand.getTabCompletions(Fabled.getGroups(), (String[])Arrays.copyOfRange(args, i, args.length));
        }
        return null;
    }
}

