/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.CommandManager;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.Filter;
import studio.magemonkey.codex.mccore.config.parse.NumberParser;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.enums.ExpSource;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.language.RPGFilter;
import studio.magemonkey.fabled.manager.CmdManager;

public class CmdExp
implements IFunction,
TabCompleter {
    public static final Pattern IS_NUMBER = Pattern.compile("-?[0-9]+");
    public static final Pattern IS_BOOL = Pattern.compile("(true)|(false)");
    private static final String NOT_PLAYER = "not-player";
    private static final String GAVE_EXP = "gave-exp";
    private static final String TOOK_EXP = "took-exp";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String ... args) {
        if (sender instanceof Player && !Fabled.getSettings().isWorldEnabled(((Player)sender).getWorld()) && args.length == 1) {
            cmd.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", new CustomFilter[0]);
        } else if (args.length >= 1 && sender instanceof Player && IS_NUMBER.matcher(args[0]).matches() || args.length >= 2) {
            boolean showMessage;
            OfflinePlayer target;
            int numberIndex;
            int n = numberIndex = IS_NUMBER.matcher(args[0]).matches() ? 0 : 1;
            if (args.length > 1 && IS_NUMBER.matcher(args[1]).matches()) {
                numberIndex = 1;
            }
            OfflinePlayer offlinePlayer = target = numberIndex == 0 ? (OfflinePlayer)sender : Bukkit.getOfflinePlayer((String)args[0]);
            if (target == null) {
                cmd.sendMessage(sender, NOT_PLAYER, ChatColor.RED + "That is not a valid player name", new CustomFilter[0]);
                return;
            }
            PlayerData data = Fabled.getData(target);
            double amount = NumberParser.parseDouble((String)args[numberIndex]);
            if (amount == 0.0) {
                return;
            }
            int lastArg = args.length - 1;
            boolean message = IS_BOOL.matcher(args[lastArg]).matches();
            boolean bl = showMessage = !message || Boolean.parseBoolean(args[lastArg]);
            if (message) {
                --lastArg;
            }
            if (numberIndex + 1 <= lastArg) {
                PlayerClass playerClass = data.getClass(CmdManager.join(args, numberIndex + 1, lastArg));
                if (playerClass == null) {
                    return;
                }
                if (amount > 0.0) {
                    playerClass.giveExp(amount, ExpSource.COMMAND, showMessage);
                    if (showMessage && target != sender) {
                        cmd.sendMessage(sender, GAVE_EXP, ChatColor.DARK_GREEN + "You have given " + ChatColor.GOLD + "{player} {exp}{class} experience", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.EXP.setReplacement("" + amount), RPGFilter.CLASS.setReplacement(" " + playerClass.getData().getGroup())});
                    }
                } else {
                    playerClass.loseExp(-amount, false, true);
                    if (showMessage && target != sender) {
                        cmd.sendMessage(sender, TOOK_EXP, ChatColor.DARK_GREEN + "You have taken " + ChatColor.GOLD + "{exp}{class} experience " + ChatColor.DARK_GREEN + "from " + ChatColor.GOLD + "{player}", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.EXP.setReplacement("" + -amount), RPGFilter.CLASS.setReplacement(" " + playerClass.getData().getGroup())});
                    }
                }
            } else if (amount > 0.0) {
                data.giveExp(amount, ExpSource.COMMAND, showMessage);
                if (showMessage && target != sender) {
                    cmd.sendMessage(sender, GAVE_EXP, ChatColor.DARK_GREEN + "You have given " + ChatColor.GOLD + "{player} {exp}{class} experience", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.EXP.setReplacement("" + amount), RPGFilter.CLASS.setReplacement("")});
                }
            } else {
                data.loseExp(-amount, false, true);
                if (showMessage && target != sender) {
                    cmd.sendMessage(sender, TOOK_EXP, ChatColor.DARK_GREEN + "You have taken " + ChatColor.GOLD + "{exp}{class} experience " + ChatColor.DARK_GREEN + "from " + ChatColor.GOLD + "{player}", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.EXP.setReplacement("" + -amount), RPGFilter.CLASS.setReplacement("")});
                }
            }
        } else {
            CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return ConfigurableCommand.getPlayerTabCompletions((CommandSender)commandSender, (String)args[0]);
        }
        if (args.length > 1 && !args[1].isBlank()) {
            int i;
            int n = i = IS_NUMBER.matcher(args[1]).matches() ? 2 : 1;
            if (i >= args.length) {
                return null;
            }
            return ConfigurableCommand.getTabCompletions(Fabled.getGroups(), (String[])Arrays.copyOfRange(args, i, args.length));
        }
        return null;
    }
}

