/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.util.TextFormatter;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.binding.BindingMenu;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.language.RPGFilter;
import studio.magemonkey.fabled.listener.BindListener;

public class CmdBind
implements IFunction,
TabCompleter {
    private static final String NOT_PLAYER = "not-player";
    private static final String NOT_SKILL = "not-skill";
    private static final String NOT_UNLOCKED = "not-unlocked";
    private static final String NO_ITEM = "no-item";
    private static final String SKILL_BOUND = "skill-bound";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand command, Plugin plugin, CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            command.sendMessage(sender, NOT_PLAYER, "&4Only players can use this command", new CustomFilter[0]);
            return;
        }
        Player player = (Player)sender;
        if (!Fabled.getSettings().isWorldEnabled(player.getWorld())) {
            command.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", new CustomFilter[0]);
            return;
        }
        ItemStack item = BindListener.getHeldItem(player.getInventory());
        if (item == null || item.getItemMeta() == null) {
            command.sendMessage(sender, NO_ITEM, "&4You are not holding an item", new CustomFilter[0]);
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (args.length >= 1) {
            PlayerData playerData = Fabled.getData((OfflinePlayer)((Player)sender));
            StringBuilder skillName = new StringBuilder(args[0]);
            for (int i = 1; i < args.length; ++i) {
                skillName.append(' ').append(args[i]);
            }
            PlayerSkill skill = playerData.getSkill(skillName.toString());
            if (skill == null) {
                command.sendMessage(sender, NOT_SKILL, "&4You do not have that skill", new CustomFilter[0]);
            } else if (skill.getLevel() == 0) {
                command.sendMessage(sender, NOT_UNLOCKED, "&4You have not unlocked that skill", new CustomFilter[0]);
            } else {
                List<String> bound = BindListener.getBoundSkills(item);
                if (!bound.contains(skill.getData().getKey())) {
                    bound.add(skill.getData().getKey());
                    BindListener.setBoundSkills(item, bound);
                }
                command.sendMessage(sender, SKILL_BOUND, "&6{skill} &2has been bound to &6{item}", new CustomFilter[]{RPGFilter.SKILL.setReplacement(skill.getData().getName()), RPGFilter.ITEM.setReplacement(meta.hasDisplayName() ? meta.getDisplayName() : TextFormatter.format((String)item.getType().name()))});
            }
        } else {
            new BindingMenu(player, item).open();
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!(commandSender instanceof Player)) {
            return null;
        }
        return ConfigurableCommand.getTabCompletions((Collection)Fabled.getData((OfflinePlayer)((Player)commandSender)).getSkills().stream().map(playerSkill -> playerSkill.getData().getName()).collect(Collectors.toList()), (String[])args);
    }
}

