/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.sql.ResultSet;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.Filter;
import studio.magemonkey.codex.mccore.config.parse.YAMLParser;
import studio.magemonkey.codex.mccore.sql.direct.SQLDatabase;
import studio.magemonkey.codex.mccore.sql.direct.SQLTable;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.data.Settings;

public class CmdBackup
implements IFunction {
    private static final String BACKUP = "backup";
    private static final String FAILED = "failed";
    private static final String DONE = "done";

    public void execute(ConfigurableCommand command, Plugin plugin, CommandSender sender, String[] args) {
        Fabled api = (Fabled)plugin;
        command.sendMessage(sender, BACKUP, "&2Starting backup asynchronously...", new CustomFilter[0]);
        new BackupTask(api, command, sender).runTaskAsynchronously((Plugin)api);
    }

    private class BackupTask
    extends BukkitRunnable {
        private final ConfigurableCommand cmd;
        private final Fabled api;
        private final CommandSender sender;

        BackupTask(Fabled api, ConfigurableCommand cmd, CommandSender sender) {
            this.api = api;
            this.cmd = cmd;
            this.sender = sender;
        }

        public void run() {
            Settings settings = Fabled.getSettings();
            int count = 0;
            SQLDatabase database = new SQLDatabase((Plugin)this.api, settings.getSqlHost(), settings.getSqlPort(), settings.getSqlDatabase(), settings.getSqlUser(), settings.getSqlPass());
            try {
                database.openConnection();
                SQLTable table = database.createTable((Plugin)this.api, "players");
                ResultSet query = table.queryAll();
                File file = new File(this.api.getDataFolder(), "players");
                file.mkdir();
                while (query.next()) {
                    String sqlYaml = query.getString("data");
                    String yaml = new YAMLParser().parseText(sqlYaml).toString();
                    String name = query.getString("Name");
                    FileOutputStream out = new FileOutputStream(new File(file, name + ".yml"));
                    BufferedWriter write = new BufferedWriter(new OutputStreamWriter(out));
                    write.write(yaml);
                    write.close();
                    ++count;
                }
                this.cmd.sendMessage(this.sender, CmdBackup.DONE, "&2SQL database backup has finished successfully", new CustomFilter[0]);
            }
            catch (Exception ex) {
                this.cmd.sendMessage(this.sender, CmdBackup.FAILED, "&4SQL database backup failed - backed up {amount} entries", new CustomFilter[]{Filter.AMOUNT.setReplacement("" + count)});
                ex.printStackTrace();
            }
            database.closeConnection();
        }
    }
}

