/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.cast.PlayerView;
import studio.magemonkey.fabled.gui.tool.GUITool;

public class PlayerCastBars
implements InventoryHolder {
    private final HashMap<Integer, String> hoverBar = new HashMap();
    private final HashMap<Integer, String> instantBar = new HashMap();
    private PlayerView view = PlayerView.INVENTORY;
    private ItemStack[] backup;
    private final PlayerData player;
    private PlayerSkill hovered;
    private long cooldown;
    private int oldSlot;

    public PlayerCastBars(PlayerData data) {
        this.player = data;
    }

    public void validate() {
        this.validate(this.hoverBar);
        this.validate(this.instantBar);
    }

    public boolean isHovering() {
        return this.view == PlayerView.HOVER_BAR;
    }

    public PlayerView getView() {
        return this.view;
    }

    private void hoverSkill(int slot) {
        if (this.hoverBar.containsKey(slot)) {
            this.hovered = this.player.getSkill(this.hoverBar.get(slot));
            this.hovered.startPreview();
        } else {
            this.hovered = null;
            this.player.setOnPreviewStop(null);
        }
    }

    private void validate(HashMap<Integer, String> map) {
        map.entrySet().removeIf(entry -> {
            String skillName = (String)entry.getValue();
            if (!this.player.hasSkill(skillName)) {
                return false;
            }
            PlayerSkill playerSkill = this.player.getSkill(skillName);
            return playerSkill == null || !playerSkill.isUnlocked() || !playerSkill.getData().canCast();
        });
    }

    public void restore() {
        if (this.view == PlayerView.INVENTORY) {
            return;
        }
        if (this.view == PlayerView.ORGANIZER) {
            this.reset();
            ItemStack[] contents = this.player.getPlayer().getInventory().getContents();
            this.update(contents, this.hoverBar, 0);
            this.update(contents, this.instantBar, 27);
        }
        this.player.getPlayer().getInventory().setContents(this.backup);
        this.view = PlayerView.INVENTORY;
        this.player.getPlayer().getInventory().setHeldItemSlot(this.oldSlot);
        this.player.setOnPreviewStop(null);
    }

    public boolean showOrganizer(final Player player) {
        if (this.view != PlayerView.INVENTORY) {
            return false;
        }
        this.view = PlayerView.ORGANIZER;
        this.backup = player.getInventory().getContents();
        ItemStack[] playerContents = new ItemStack[36];
        this.fill(playerContents, this.hoverBar, 0);
        this.fill(playerContents, this.instantBar, 27);
        int castSlot = Fabled.getSettings().getCastSlot();
        playerContents[castSlot] = Fabled.getSettings().getHoverItem();
        playerContents[castSlot + 27] = Fabled.getSettings().getInstantItem();
        HashSet<String> unused = this.getUnused();
        final Inventory inv = player.getServer().createInventory((InventoryHolder)this, 54);
        ItemStack[] contents = new ItemStack[54];
        int i = 0;
        int j = 9;
        for (String skill : unused) {
            if (i < contents.length) {
                contents[i++] = this.makeIndicator(skill);
                continue;
            }
            if (j >= 27) continue;
            playerContents[j++] = this.makeIndicator(skill);
        }
        player.getInventory().setContents(playerContents);
        inv.setContents(contents);
        this.oldSlot = player.getInventory().getHeldItemSlot();
        new BukkitRunnable(){

            public void run() {
                player.openInventory(inv);
            }
        }.runTask((Plugin)Fabled.inst());
        return true;
    }

    private void fill(ItemStack[] contents, HashMap<Integer, String> bar, int index) {
        for (Map.Entry<Integer, String> entry : bar.entrySet()) {
            contents[index + entry.getKey().intValue()] = this.makeIndicator(entry.getValue());
        }
    }

    private void update(ItemStack[] contents, HashMap<Integer, String> bar, int index) {
        int castSlot = Fabled.getSettings().getCastSlot();
        for (int i = 0; i < 9; ++i) {
            String skillName;
            PlayerSkill skill;
            List lore;
            ItemMeta meta;
            if (i == castSlot || contents[i + index] == null || (meta = contents[i + index].getItemMeta()) == null || (lore = meta.getLore()) == null || (skill = this.player.getSkill(skillName = (String)lore.get(lore.size() - 1))) == null) continue;
            bar.put(i, skillName);
        }
    }

    private ItemStack makeIndicator(String skill) {
        if (skill == null) {
            return null;
        }
        ItemStack item = Fabled.getSkill(skill).getIndicator(this.player.getSkill(skill), true);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            lore.add(skill);
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return GUITool.markCastItem(item);
    }

    public boolean showHoverBar(Player player) {
        if (this.show(player, PlayerView.HOVER_BAR, this.hoverBar)) {
            this.hoverSkill(player.getInventory().getHeldItemSlot());
            if (this.hovered != null) {
                this.hovered.startPreview();
            }
            return true;
        }
        return false;
    }

    public boolean showInstantBar(Player player) {
        return this.show(player, PlayerView.INSTANT_BAR, this.instantBar);
    }

    private boolean show(Player player, PlayerView view, HashMap<Integer, String> bar) {
        long left = System.currentTimeMillis() - this.cooldown - Fabled.getSettings().getCastCooldown();
        if (this.view != PlayerView.INVENTORY || bar.isEmpty() || left < 0L) {
            return false;
        }
        this.view = view;
        this.backup = player.getInventory().getContents();
        ItemStack[] contents = new ItemStack[36];
        this.makeContents(bar, contents, 0);
        player.getInventory().setContents(contents);
        player.getInventory().setItem(Fabled.getSettings().getCastSlot(), Fabled.getSettings().getCastItem());
        return true;
    }

    public boolean handle(PlayerItemHeldEvent event) {
        switch (this.view) {
            case INSTANT_BAR: {
                if (this.instantBar.containsKey(event.getNewSlot())) {
                    this.player.cast(this.instantBar.get(event.getNewSlot()));
                    this.cooldown = System.currentTimeMillis();
                }
                this.restore();
                event.setCancelled(true);
                return true;
            }
            case HOVER_BAR: {
                this.hoverSkill(event.getNewSlot());
                return true;
            }
            case INVENTORY: {
                this.oldSlot = event.getPreviousSlot();
                return false;
            }
        }
        return false;
    }

    public boolean handleInteract(Player player) {
        switch (this.view) {
            case INSTANT_BAR: {
                this.restore();
                return true;
            }
            case HOVER_BAR: {
                if (this.hoverBar.containsKey(player.getInventory().getHeldItemSlot())) {
                    this.player.cast(this.hoverBar.get(player.getInventory().getHeldItemSlot()));
                    this.cooldown = System.currentTimeMillis();
                }
                this.restore();
                return true;
            }
        }
        return false;
    }

    public void handleOpen() {
        if (this.view == PlayerView.HOVER_BAR || this.view == PlayerView.INSTANT_BAR) {
            this.restore();
        }
    }

    public void unlock(PlayerSkill skill) {
        if (!this.addTo(this.hoverBar, skill)) {
            this.addTo(this.instantBar, skill);
        }
        this.validate();
    }

    private boolean addTo(HashMap<Integer, String> bar, PlayerSkill skill) {
        for (int i = 0; i < 9; ++i) {
            if (bar.containsKey(i)) continue;
            this.add(bar, skill.getData().getName(), i);
            return true;
        }
        return false;
    }

    private void add(HashMap<Integer, String> bar, String skill, int slot) {
        bar.put(slot, skill);
    }

    public void reset() {
        this.instantBar.clear();
        this.hoverBar.clear();
    }

    private HashSet<String> getUnused() {
        HashSet<String> unused = new HashSet<String>();
        for (PlayerSkill skill : this.player.getSkills()) {
            String name;
            if (!skill.isUnlocked() || !skill.getData().canCast() || this.hoverBar.containsValue(name = skill.getData().getName()) || this.instantBar.containsValue(name)) continue;
            unused.add(name);
        }
        return unused;
    }

    private void makeContents(HashMap<Integer, String> slots, ItemStack[] contents, int offset) {
        for (Map.Entry<Integer, String> slot : slots.entrySet()) {
            PlayerSkill skill = this.player.getSkill(slot.getValue());
            if (skill == null) continue;
            contents[offset + slot.getKey().intValue()] = GUITool.markCastItem(skill.getData().getIndicator(skill, true));
        }
    }

    public void load(DataSection config, boolean hover) {
        if (config == null) {
            return;
        }
        HashMap<Integer, String> bar = hover ? this.hoverBar : this.instantBar;
        for (String key : config.keys()) {
            this.add(bar, key, config.getInt(key));
        }
        this.validate(bar);
    }

    public void save(DataSection config, boolean hover) {
        HashMap<Integer, String> bar = hover ? this.hoverBar : this.instantBar;
        for (Map.Entry<Integer, String> entry : bar.entrySet()) {
            config.set(entry.getValue(), (Object)entry.getKey());
        }
    }

    public Inventory getInventory() {
        return null;
    }
}

