/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.projectile;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.Metadatable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.event.ItemProjectileExpireEvent;
import studio.magemonkey.fabled.api.event.ItemProjectileHitEvent;
import studio.magemonkey.fabled.api.event.ItemProjectileLandEvent;
import studio.magemonkey.fabled.api.event.ItemProjectileLaunchEvent;
import studio.magemonkey.fabled.api.projectile.CustomProjectile;
import studio.magemonkey.fabled.api.projectile.ProjectileCallback;
import studio.magemonkey.fabled.api.target.TargetHelper;
import studio.magemonkey.fabled.api.util.DamageLoreRemover;
import studio.magemonkey.fabled.api.util.Nearby;
import studio.magemonkey.fabled.dynamic.DynamicSkill;

public class ItemProjectile
extends CustomProjectile {
    private static final String NAME = "Fabled#";
    public static final String HOMING = "homing";
    public static final String HOMING_TARGET = "target";
    public static final String HOMING_DIST = "homing-distance";
    public static final String REMEMBER = "remember-key";
    public static final String CORRECTION = "correction";
    public static final String WALL = "wall";
    public static final String RADIUS = "collision-radius";
    private static int NEXT = 0;
    private final Item item;
    private int life;
    private final boolean walls;
    private final double speed;
    protected Supplier<LivingEntity> homing;
    protected double correction;
    protected double radius;
    private static final Vector X_AXIS = new Vector(1, 0, 0);
    private static final Vector Y_AXIS = new Vector(0, 1, 0);
    private static final Vector Z_AXIS = new Vector(0, 0, 1);

    public ItemProjectile(LivingEntity thrower, int level, Location loc, Settings settings, ItemStack item, Vector vel, int lifespan, boolean collideWalls) {
        super(thrower, settings);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(NAME + NEXT++);
            item.setItemMeta(meta);
        }
        DamageLoreRemover.removeAttackDmg(item);
        this.item = thrower.getWorld().dropItem(loc, item);
        this.item.setVelocity(vel);
        this.speed = vel.length();
        this.item.setPickupDelay(Integer.MAX_VALUE);
        this.walls = collideWalls;
        this.life = lifespan;
        this.radius = settings.getAttr(RADIUS, level, 0.2);
        Fabled.setMeta((Metadatable)this.item, "itemProjectile", this);
        if (settings.getBool(HOMING, false)) {
            String target = settings.getString(HOMING_TARGET, "nearest");
            Comparator<LivingEntity> comparator = Comparator.comparingDouble(o -> o.getLocation().distanceSquared(this.getLocation()));
            this.homing = target.equalsIgnoreCase("remember target") ? () -> {
                Object data = DynamicSkill.getCastData(this.getShooter()).getRaw(this.settings.getString(REMEMBER, HOMING_TARGET));
                if (data == null) {
                    return null;
                }
                try {
                    return ((List)data).stream().filter(tar -> this.settings.getBool(WALL, false) || !TargetHelper.isObstructed(this.getLocation(), tar.getEyeLocation())).min(comparator).orElse(null);
                }
                catch (ClassCastException e) {
                    return null;
                }
            } : () -> Nearby.getLivingNearby(this.getLocation(), this.settings.getAttr(HOMING_DIST, 0, 20.0)).stream().filter(tar -> {
                if (tar == this.getShooter()) {
                    return false;
                }
                if (!Fabled.getSettings().isValidTarget((LivingEntity)tar)) {
                    return false;
                }
                boolean ally = Fabled.getSettings().isAlly(this.getShooter(), (LivingEntity)tar);
                if (ally && !this.ally) {
                    return false;
                }
                return ally || this.enemy;
            }).filter(tar -> this.settings.getBool(WALL, false) || !TargetHelper.isObstructed(this.getLocation(), tar.getEyeLocation())).min(comparator).orElse(null);
            this.correction = settings.getAttr(CORRECTION, 0, 0.2);
        }
        Bukkit.getPluginManager().callEvent((Event)new ItemProjectileLaunchEvent(this));
    }

    public Item getItem() {
        return this.item;
    }

    @Override
    public Location getLocation() {
        return this.item.getLocation();
    }

    @Override
    protected Event expire() {
        return this.land();
    }

    @Override
    protected Event land() {
        return new ItemProjectileLandEvent(this);
    }

    @Override
    protected Event hit(LivingEntity entity) {
        return new ItemProjectileHitEvent(this, entity);
    }

    @Override
    protected boolean landed() {
        if (this.item.isOnGround()) {
            return true;
        }
        if (this.walls) {
            Vector velocity = this.item.getVelocity();
            RayTraceResult raytrace = this.item.getWorld().rayTraceBlocks(this.item.getLocation(), velocity, velocity.length(), FluidCollisionMode.NEVER, true);
            if (raytrace == null) {
                raytrace = this.collideWall(velocity, X_AXIS);
            }
            if (raytrace == null) {
                raytrace = this.collideWall(velocity, Z_AXIS);
            }
            if (raytrace == null) {
                raytrace = this.collideWall(velocity, Y_AXIS);
            }
            if (raytrace != null) {
                this.item.teleport(raytrace.getHitPosition().toLocation(this.item.getWorld()));
                return true;
            }
        }
        return false;
    }

    @Nullable
    private RayTraceResult collideWall(Vector direction, Vector defaultDirection) {
        direction = direction.clone();
        direction.multiply(defaultDirection);
        if (direction.lengthSquared() == 0.0) {
            RayTraceResult result = this.collideWall(defaultDirection, defaultDirection);
            if (result == null) {
                result = this.collideWall(defaultDirection.clone().multiply(-1), defaultDirection);
            }
            return result;
        }
        return this.item.getWorld().rayTraceBlocks(this.item.getLocation().add(0.0, 0.125, 0.0), direction, this.radius + 0.1, FluidCollisionMode.NEVER, true);
    }

    @Override
    protected double getCollisionRadius() {
        return this.radius;
    }

    @Override
    protected Vector getVelocity() {
        return this.item.getVelocity();
    }

    @Override
    protected void setVelocity(Vector velocity) {
        this.item.setVelocity(velocity);
    }

    public void run() {
        LivingEntity target;
        if (this.homing != null && (target = this.homing.get()) != null) {
            Vector acceleration = target.getBoundingBox().getCenter().subtract(this.item.getBoundingBox().getCenter()).normalize().multiply(this.speed).subtract(this.item.getVelocity());
            double length = acceleration.length();
            acceleration.multiply(1.0 / length).multiply(Math.min(length, this.correction));
            this.item.setVelocity(this.item.getVelocity().add(acceleration));
        }
        if (this.isTraveling()) {
            this.checkCollision(false);
        }
        --this.life;
        if (this.life <= 0) {
            if (this.settings.getBool("on-expire") && this.callback != null) {
                this.callback.callback(this, null);
            }
            this.cancel();
            Bukkit.getPluginManager().callEvent((Event)new ItemProjectileExpireEvent(this));
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.item.remove();
    }

    public static List<ItemProjectile> spread(LivingEntity shooter, int level, Vector direction, Location loc, Settings settings, ItemStack item, double angle, int amount, ProjectileCallback callback, int lifespan, boolean collideWalls) {
        double speed = direction.length();
        direction.normalize();
        List<Vector> dirs = ItemProjectile.calcSpread(shooter.getLocation().getDirection(), angle, amount);
        ArrayList<ItemProjectile> list = new ArrayList<ItemProjectile>();
        for (Vector dir : dirs) {
            Vector vel = dir.multiply(speed);
            ItemProjectile p = new ItemProjectile(shooter, level, loc, settings, item, vel, lifespan, collideWalls);
            p.setCallback(callback);
            list.add(p);
        }
        return list;
    }

    public static List<ItemProjectile> rain(LivingEntity shooter, int level, Location center, Settings settings, ItemStack item, double radius, double height, double speed, int amount, ProjectileCallback callback, int lifespan, boolean collideWalls) {
        Vector vel = new Vector(0.0, speed, 0.0);
        List<Location> locs = ItemProjectile.calcRain(center, radius, height, amount);
        ArrayList<ItemProjectile> list = new ArrayList<ItemProjectile>();
        for (Location l : locs) {
            l.setDirection(vel);
            ItemProjectile p = new ItemProjectile(shooter, level, l, settings, item, vel, lifespan, collideWalls);
            p.setCallback(callback);
            list.add(p);
        }
        return list;
    }
}

