/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.particle;

import java.util.Set;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import studio.magemonkey.fabled.api.particle.IParticleEffect;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.api.particle.TimeBasedTransform;
import studio.magemonkey.fabled.data.Point3D;
import studio.magemonkey.fabled.data.formula.Formula;

public class ParticleImage
implements IParticleEffect {
    private final String name;
    private final Color[][] colors;
    private final Point3D[][] points;
    private final Formula particleSizeFormula;
    private final int interval;
    private final int iterationsPerFrame;
    private final int view;
    private final boolean withRotation;
    private final TimeBasedTransform transform;

    @Override
    public void play(Location loc, int frame, int level) {
        if (loc == null || loc.getWorld() == null) {
            return;
        }
        World world = loc.getWorld();
        Set<Player> players = ParticleHelper.filterPlayers(world.getPlayers(), loc, this.view);
        if (players.isEmpty()) {
            return;
        }
        int gifFrame = this.iterationsPerFrame == 0 ? 1 : frame / this.iterationsPerFrame;
        Point3D[] framePoints = this.points[gifFrame % this.points.length];
        Color[] colors = this.colors[gifFrame % this.colors.length];
        Point3D[] displayPoints = framePoints;
        if (this.transform != null) {
            displayPoints = this.transform.apply(displayPoints, loc, this.withRotation, frame, level);
        }
        float particleSize = (float)this.particleSizeFormula.compute(frame, level);
        for (int i = 0; i < displayPoints.length; ++i) {
            Point3D point = displayPoints[i];
            Color color = colors[i];
            if (color == null) continue;
            Location location = loc.clone().add(point.x, point.y, point.z);
            for (Player player : players) {
                Particle particle;
                if (player.getLocation().distance(location) > (double)this.view) continue;
                try {
                    particle = Particle.DUST;
                }
                catch (Exception e) {
                    particle = Particle.valueOf((String)"REDSTONE");
                }
                player.spawnParticle(particle, location, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(color, particleSize));
            }
        }
    }

    public ParticleImage(String name, Color[][] colors, Point3D[][] points, Formula particleSizeFormula, int interval, int iterationsPerFrame, int view, boolean withRotation, TimeBasedTransform transform) {
        this.name = name;
        this.colors = colors;
        this.points = points;
        this.particleSizeFormula = particleSizeFormula;
        this.interval = interval;
        this.iterationsPerFrame = iterationsPerFrame;
        this.view = view;
        this.withRotation = withRotation;
        this.transform = transform;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getInterval() {
        return this.interval;
    }
}

