/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.event;

import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.api.player.PlayerData;

public class PlayerExperienceLostEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final PlayerClass playerClass;
    private boolean cancelled;
    private boolean changeLevel;
    private double amount;

    public PlayerExperienceLostEvent(PlayerClass playerClass, double amount, boolean changeLevel) {
        this.playerClass = playerClass;
        this.amount = amount;
        this.changeLevel = changeLevel;
        this.cancelled = false;
    }

    public PlayerData getPlayerData() {
        return this.playerClass.getPlayerData();
    }

    public PlayerClass getPlayerClass() {
        return this.playerClass;
    }

    public double getExp() {
        return this.amount;
    }

    public boolean isLevelChangeAllowed() {
        return this.changeLevel;
    }

    public void setExp(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Experience cannot be negative");
        }
        this.amount = amount;
    }

    public void setLevelChangeAllowed(boolean changeLevel) {
        this.changeLevel = changeLevel;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

