/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.event;

import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import studio.magemonkey.fabled.api.enums.ExpSource;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.api.player.PlayerData;

public class PlayerExperienceGainEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private PlayerClass playerClass;
    private boolean cancelled;
    private ExpSource source;
    private double amount;

    public PlayerExperienceGainEvent(PlayerClass playerClass, double amount, ExpSource source) {
        this.playerClass = playerClass;
        this.amount = amount;
        this.source = source;
        this.cancelled = false;
    }

    public PlayerData getPlayerData() {
        return this.playerClass.getPlayerData();
    }

    public PlayerClass getPlayerClass() {
        return this.playerClass;
    }

    public double getExp() {
        return this.amount;
    }

    public ExpSource getSource() {
        return this.source;
    }

    public void setExp(double amount) {
        if (amount < 0.0) {
            throw new IllegalArgumentException("Experience cannot be negative");
        }
        this.amount = amount;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

