/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.classes;

import java.util.Locale;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.classes.TreeType;
import studio.magemonkey.fabled.tree.basic.BasicHorizontalTree;
import studio.magemonkey.fabled.tree.basic.BasicVerticalTree;
import studio.magemonkey.fabled.tree.basic.CustomTree;
import studio.magemonkey.fabled.tree.basic.FloodTree;
import studio.magemonkey.fabled.tree.basic.InventoryTree;
import studio.magemonkey.fabled.tree.basic.LevelHorizontalTree;
import studio.magemonkey.fabled.tree.basic.LevelVerticalTree;
import studio.magemonkey.fabled.tree.basic.RequirementTree;

public enum DefaultTreeType implements TreeType
{
    BASIC_HORIZONTAL,
    BASIC_VERTICAL,
    LEVEL_HORIZONTAL,
    LEVEL_VERTICAL,
    FLOOD,
    REQUIREMENT,
    CUSTOM;


    @Override
    public InventoryTree getTree(Fabled api, FabledClass parent) {
        switch (this) {
            case BASIC_HORIZONTAL: {
                return new BasicHorizontalTree(api, parent);
            }
            case BASIC_VERTICAL: {
                return new BasicVerticalTree(api, parent);
            }
            case LEVEL_HORIZONTAL: {
                return new LevelHorizontalTree(api, parent);
            }
            case LEVEL_VERTICAL: {
                return new LevelVerticalTree(api, parent);
            }
            case FLOOD: {
                return new FloodTree(api, parent);
            }
            case REQUIREMENT: {
                return new RequirementTree(api, parent);
            }
            case CUSTOM: {
                return new CustomTree(api, parent);
            }
        }
        return null;
    }

    public static DefaultTreeType getByName(String name) {
        try {
            return Enum.valueOf(DefaultTreeType.class, name.toUpperCase(Locale.US).replace(' ', '_'));
        }
        catch (Exception ex) {
            return REQUIREMENT;
        }
    }
}

