/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.manager.api.menu.Menu;
import studio.magemonkey.codex.manager.api.menu.Slot;
import studio.magemonkey.codex.manager.api.menu.YAMLMenu;
import studio.magemonkey.codex.mccore.util.TextFormatter;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.listener.BindListener;

public class BindingMenu
extends Menu {
    public static final NamespacedKey SKILL_KEY = new NamespacedKey((Plugin)Fabled.inst(), "skill");
    public static final YAMLMenu<ItemStack> CONFIG = new YAMLMenu<ItemStack>((Plugin)Fabled.inst(), "menus/binding.yml"){

        protected String getTitle(String yamlTitle, @NotNull ItemStack itemStack) {
            ItemMeta meta = Objects.requireNonNull(itemStack.getItemMeta());
            return yamlTitle.replace("%item%", meta.hasDisplayName() ? meta.getDisplayName() : TextFormatter.format((String)itemStack.getType().name()));
        }

        public Slot getSlot(String key, final ItemStack item, Player player) {
            ItemStack configItem = this.getItem(key);
            return switch (key) {
                case "clear" -> new Slot(configItem){

                    public void onLeftClick() {
                        BindListener.setBoundSkills(item, null);
                        this.menu.open();
                    }
                };
                case "bound-prev-page" -> new Slot(configItem){

                    public void onLeftClick() {
                        --((BindingMenu)this.menu).boundPage;
                        this.menu.open();
                    }
                };
                case "bound-next-page" -> new Slot(configItem){

                    public void onLeftClick() {
                        ++((BindingMenu)this.menu).boundPage;
                        this.menu.open();
                    }
                };
                case "bound" -> new Slot(configItem){

                    public void onLeftClick() {
                        String currentSkill;
                        List<String> inItem = BindListener.getBoundSkills(item);
                        int current = inItem.indexOf(currentSkill = (String)Objects.requireNonNull(this.getItemStack().getItemMeta()).getPersistentDataContainer().get(SKILL_KEY, PersistentDataType.STRING));
                        if (current <= 0) {
                            this.menu.open();
                            return;
                        }
                        int prev = current - 1;
                        String prevSkill = inItem.get(prev);
                        inItem.set(current, prevSkill);
                        inItem.set(prev, currentSkill);
                        BindListener.setBoundSkills(item, inItem);
                        this.menu.open();
                    }

                    public void onRightClick() {
                        String currentSkill;
                        List<String> inItem = BindListener.getBoundSkills(item);
                        int current = inItem.indexOf(currentSkill = (String)Objects.requireNonNull(this.getItemStack().getItemMeta()).getPersistentDataContainer().get(SKILL_KEY, PersistentDataType.STRING));
                        if (current < 0 || current == inItem.size() - 1) {
                            this.menu.open();
                            return;
                        }
                        int next = current + 1;
                        String nextSkill = inItem.get(next);
                        inItem.set(current, nextSkill);
                        inItem.set(next, currentSkill);
                        BindListener.setBoundSkills(item, inItem);
                        this.menu.open();
                    }

                    public void onDrop() {
                        List<String> inItem = BindListener.getBoundSkills(item);
                        inItem.remove(Objects.requireNonNull(this.getItemStack().getItemMeta()).getPersistentDataContainer().get(SKILL_KEY, PersistentDataType.STRING));
                        BindListener.setBoundSkills(item, inItem);
                        this.menu.open();
                    }
                };
                case "not-bound-prev-page" -> new Slot(configItem){

                    public void onLeftClick() {
                        --((BindingMenu)this.menu).notBoundPage;
                        this.menu.open();
                    }
                };
                case "not-bound-next-page" -> new Slot(configItem){

                    public void onLeftClick() {
                        ++((BindingMenu)this.menu).notBoundPage;
                        this.menu.open();
                    }
                };
                case "not-bound" -> new Slot(configItem){

                    public void onLeftClick() {
                        String skill = (String)Objects.requireNonNull(this.getItemStack().getItemMeta()).getPersistentDataContainer().get(SKILL_KEY, PersistentDataType.STRING);
                        List<String> inItem = BindListener.getBoundSkills(item);
                        if (!inItem.contains(skill)) {
                            inItem.add(skill);
                            BindListener.setBoundSkills(item, inItem);
                        }
                        this.menu.open();
                    }
                };
                default -> new Slot(configItem);
            };
        }
    };
    private final ItemStack itemStack;
    private int boundPage = 0;
    private int notBoundPage = 0;

    public BindingMenu(Player player, ItemStack itemStack) {
        super(player, CONFIG.getRows(), CONFIG.getTitle((Object)itemStack));
        this.itemStack = itemStack;
    }

    public void setContents() {
        this.registerListener(new Listener(){

            @EventHandler
            public void onInventoryClick(InventoryClickEvent event) {
                if (event.getView().getTopInventory().getHolder() != BindingMenu.this) {
                    return;
                }
                if (event.getSlotType() == InventoryType.SlotType.QUICKBAR) {
                    event.setCancelled(true);
                } else {
                    switch (event.getClick()) {
                        case NUMBER_KEY: 
                        case DOUBLE_CLICK: 
                        case SWAP_OFFHAND: {
                            event.setCancelled(true);
                        }
                    }
                }
            }
        });
        PlayerData playerData = Fabled.getData((OfflinePlayer)this.player);
        List<PlayerSkill> boundSkills = BindListener.getBoundSkills(this.itemStack, playerData);
        BindListener.setBoundSkills(this.itemStack, boundSkills.stream().map(skill -> skill.getData().getKey()).collect(Collectors.toList()));
        List notBoundSkills = playerData.getSkills().stream().filter(skill -> skill.getLevel() > 0 && !boundSkills.contains(skill)).collect(Collectors.toList());
        int boundSlots = 0;
        int notBoundSlots = 0;
        for (Map.Entry entry : CONFIG.getSlots().entrySet()) {
            if ((Integer)entry.getKey() >= this.inventory.getSize()) {
                return;
            }
            if (((String)entry.getValue()).equalsIgnoreCase("bound")) {
                ++boundSlots;
                continue;
            }
            if (!((String)entry.getValue()).equalsIgnoreCase("not-bound")) continue;
            ++notBoundSlots;
        }
        int boundPages = boundSkills.size() / (boundSlots + 1) + 1;
        int notBoundPages = notBoundSkills.size() / (notBoundSlots + 1) + 1;
        this.boundPage = (this.boundPage % boundPages + boundPages) % boundPages;
        this.notBoundPage = (this.notBoundPage % notBoundPages + notBoundPages) % notBoundPages;
        int bound = this.boundPage * boundSlots;
        int notBound = this.notBoundPage * notBoundSlots;
        block15: for (Map.Entry entry : CONFIG.getSlots().entrySet()) {
            if ((Integer)entry.getKey() >= this.inventory.getSize()) {
                return;
            }
            Slot slot = CONFIG.getSlot((String)entry.getValue(), (Object)this.itemStack, this.player);
            if (slot == null) continue;
            switch ((String)entry.getValue()) {
                case "bound-prev-page": 
                case "bound-next-page": {
                    if (boundPages > 1) break;
                    continue block15;
                }
                case "bound": {
                    ItemMeta indicatorMeta;
                    ItemStack indicator;
                    if (bound >= boundSkills.size()) continue block15;
                    PlayerSkill skill2 = boundSkills.get(bound++);
                    ItemStack slotItemStack = slot.getItemStack();
                    ItemMeta meta = slotItemStack.getItemMeta();
                    if (slotItemStack.getType().equals((Object)Material.JACK_O_LANTERN)) {
                        indicator = skill2.getData().getIndicator(skill2, false);
                        slotItemStack.setType(indicator.getType());
                        slotItemStack.setAmount(indicator.getAmount());
                        indicatorMeta = indicator.getItemMeta();
                        if (meta != null && indicatorMeta != null) {
                            meta.setDisplayName(meta.getDisplayName().replace("%display-name%", indicatorMeta.getDisplayName()));
                            meta.setLore(StringUT.replace(meta.hasLore() ? Objects.requireNonNull(meta.getLore()) : new ArrayList(), (String)"%lore%", indicatorMeta.hasLore() ? Objects.requireNonNull(indicatorMeta.getLore()) : new ArrayList()));
                            if (indicatorMeta.hasCustomModelData()) {
                                meta.setCustomModelData(Integer.valueOf(indicatorMeta.getCustomModelData()));
                            }
                        }
                        if (meta != null) {
                            meta.getPersistentDataContainer().set(SKILL_KEY, PersistentDataType.STRING, (Object)skill2.getData().getKey());
                            slotItemStack.setItemMeta(meta);
                        }
                    }
                    slot.setItemStack(slotItemStack);
                    break;
                }
                case "not-bound-prev-page": 
                case "not-bound-next-page": {
                    if (notBoundPages > 1) break;
                    continue block15;
                }
                case "not-bound": {
                    ItemMeta indicatorMeta;
                    ItemStack indicator;
                    if (notBound >= notBoundSkills.size()) continue block15;
                    PlayerSkill skill2 = (PlayerSkill)notBoundSkills.get(notBound++);
                    ItemStack slotItemStack = slot.getItemStack();
                    ItemMeta meta = slotItemStack.getItemMeta();
                    if (slotItemStack.getType().equals((Object)Material.JACK_O_LANTERN)) {
                        indicator = skill2.getData().getIndicator(skill2, false);
                        slotItemStack.setType(indicator.getType());
                        slotItemStack.setAmount(indicator.getAmount());
                        indicatorMeta = indicator.getItemMeta();
                        if (meta != null && indicatorMeta != null) {
                            meta.setDisplayName(meta.getDisplayName().replace("%display-name%", indicatorMeta.getDisplayName()));
                            meta.setLore(StringUT.replace(meta.hasLore() ? Objects.requireNonNull(meta.getLore()) : new ArrayList(), (String)"%lore%", indicatorMeta.hasLore() ? Objects.requireNonNull(indicatorMeta.getLore()) : new ArrayList()));
                            if (indicatorMeta.hasCustomModelData()) {
                                meta.setCustomModelData(Integer.valueOf(indicatorMeta.getCustomModelData()));
                            }
                        }
                    }
                    if (meta != null) {
                        meta.getPersistentDataContainer().set(SKILL_KEY, PersistentDataType.STRING, (Object)skill2.getData().getKey());
                        slotItemStack.setItemMeta(meta);
                    }
                    slot.setItemStack(slotItemStack);
                }
            }
            this.setSlot((Integer)entry.getKey(), slot);
        }
    }

    public void onClose() {
        super.onClose();
        if (!Fabled.getSettings().isWorldEnabled(this.player.getWorld())) {
            return;
        }
        PlayerData playerData = Fabled.getData((OfflinePlayer)this.player);
        playerData.setOnPreviewStop(null);
        List<PlayerSkill> boundSkills = BindListener.getBoundSkills(this.itemStack, playerData);
        if (boundSkills.isEmpty()) {
            return;
        }
        boundSkills.get(BindListener.getIndex(this.player, boundSkills.size())).startPreview();
    }
}

