/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import studio.magemonkey.codex.mccore.util.MobManager;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.PlayerDataConsumer;
import studio.magemonkey.fabled.api.player.PlayerData;

public class CastData {
    private final Map<String, Object> data = new HashMap<String, Object>();

    public CastData(LivingEntity caster) {
        this.data.put("caster", caster);
        if (caster instanceof Player) {
            for (String attr : Fabled.getAttributeManager().getAttributes().keySet()) {
                this.data.put("attr:" + attr.toLowerCase(), () -> {
                    PlayerData playerData = Fabled.getData((OfflinePlayer)((Player)caster));
                    int stage = playerData.getInvestedAttributeStage(attr);
                    return stage;
                });
            }
        }
    }

    public boolean contains(String key) {
        return this.data.containsKey(key) && this.data.get(key) != null;
    }

    public Object getRaw(String key) {
        return this.data.get(key);
    }

    public double getDouble(String key) {
        double value = 0.0;
        Object raw = this.getRaw(key);
        if (raw instanceof PlayerDataConsumer) {
            raw = ((PlayerDataConsumer)raw).consume();
        }
        try {
            value = Double.parseDouble(raw.toString());
        }
        catch (Exception ex) {
            Fabled.inst().getLogger().warning("Could not convert " + raw + " to double.");
        }
        return value;
    }

    public String get(String key) {
        if (!this.contains(key)) {
            return null;
        }
        Object obj = this.data.get(key);
        if (obj instanceof Player) {
            obj = ((Player)obj).getName();
        } else if (obj instanceof LivingEntity) {
            obj = MobManager.getName((LivingEntity)((LivingEntity)obj));
        } else if (obj instanceof PlayerDataConsumer) {
            obj = ((PlayerDataConsumer)obj).consume();
        }
        return obj.toString();
    }

    public String getOrDefault(String key, String def) {
        String val = this.get(key);
        if (val != null) {
            return val;
        }
        return def;
    }

    public void put(String key, Object value) {
        this.data.put(key, value);
    }

    public void remove(String key) {
        this.data.remove(key);
    }
}

