/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.stations;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.lumine.mythic.api.volatilecode.VolatileEnchantment;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.config.properties.types.BooleanProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.DoubleProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.Int2IntMapProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.config.Scope;
import io.lumine.mythicenchants.enchants.EnchantManager;
import io.lumine.mythicenchants.enchants.MythicEnchant;
import io.lumine.mythicenchants.enchants.stations.AbstractEnchantmentStationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.Player;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class EnchantmentTableHandler
extends AbstractEnchantmentStationHandler
implements PropertyHolder {
    private static final BooleanProp TABLE_ENABLED = Property.Boolean((Object)((Object)Scope.CONFIG), (String)"Enabled", (boolean)true);
    private static final DoubleProp TABLE_CHANCE = Property.Double((Object)((Object)Scope.CONFIG), (String)"Chance.Base", (double)0.01);
    private static final DoubleProp TABLE_BOOK_MOD = Property.Double((Object)((Object)Scope.CONFIG), (String)"Chance.BookMultiplier", (double)0.5);
    private static final DoubleProp TABLE_PER_ENCH_MOD = Property.Double((Object)((Object)Scope.CONFIG), (String)"Chance.ProbabilityMultiplier", (double)0.5);
    private static final StringProp TABLE_FAKE_IRREGULAR_ENCHANT = Property.String((Object)((Object)Scope.CONFIG), (String)"FakeEnchant", (String)"DURABILITY");
    private static final StringListProp ENCHANTABLE_ITEMS = Property.StringList((Object)((Object)Scope.CONFIG), (String)"ExtraEnchantableItems");
    private static final Int2IntMapProp TABLE_MAX_LEVEL = Property.Int2IntMap((Object)((Object)Scope.CONFIG), (String)"Maximum.Level");
    private static final Int2IntMapProp TABLE_ENCHANT_CAP = Property.Int2IntMap((Object)((Object)Scope.CONFIG), (String)"Maximum.Amount");
    private static final int DEFAULT_MAX_LEVEL = 30;
    private static final int MIN_BOOKSHELF_BONUS = 1;
    private static final int MAX_BOOKSHELF_BONUS = 15;
    private Enchantment fakeIrregularEnchant = VolatileEnchantment.UNBREAKING;
    private Collection<Material> enchantableMaterials = Sets.newConcurrentHashSet();
    private Map<Integer, Integer> maxLevelEnchantingTable = Maps.newConcurrentMap();
    private Map<Integer, Integer> maxEnchants = Maps.newConcurrentMap();
    private final Map<Player, int[]> enchantingLevels = Maps.newConcurrentMap();

    public EnchantmentTableHandler(MythicEnchants mythicEnchants, EnchantManager enchantManager) {
        super(mythicEnchants, enchantManager);
    }

    @Override
    public void load(MythicEnchants mythicEnchants) {
        this.enchantableMaterials = Sets.newConcurrentHashSet();
        this.maxLevelEnchantingTable = Maps.newConcurrentMap();
        this.maxEnchants = Maps.newConcurrentMap();
        this.fakeIrregularEnchant = VolatileEnchantment.UNBREAKING;
        super.load(mythicEnchants);
    }

    @Override
    public void unload() {
    }

    @Override
    protected void subscribeHandlerEvents() {
        Log.info((String)"Loading EnchantingTable Manager...");
        if (Boolean.FALSE.equals(TABLE_ENABLED.get())) {
            return;
        }
        this.fakeIrregularEnchant = Enchantment.getByName((String)((String)TABLE_FAKE_IRREGULAR_ENCHANT.get((PropertyHolder)this)));
        this.enchantableMaterials.clear();
        for (String value : (List)ENCHANTABLE_ITEMS.get((PropertyHolder)this)) {
            try {
                this.enchantableMaterials.add(Material.valueOf((String)value.toUpperCase()));
            }
            catch (Error | Exception ex) {
                Log.error((String)"Invalid enchatable material {0}", (Object[])new Object[]{value});
            }
        }
        this.maxEnchants = (Map)TABLE_ENCHANT_CAP.get((PropertyHolder)this);
        this.maxLevelEnchantingTable = (Map)TABLE_MAX_LEVEL.get((PropertyHolder)this);
        Events.subscribe(EnchantItemEvent.class).handler(this::enchantItem).bindWith((TerminableConsumer)this);
        Events.subscribe(PrepareItemEnchantEvent.class).handler(this::prepareEnchants).bindWith((TerminableConsumer)this);
        Events.subscribe(PlayerQuitEvent.class).handler(event -> this.enchantingLevels.remove(event.getPlayer())).bindWith((TerminableConsumer)this);
    }

    public void enchantItem(EnchantItemEvent event) {
        Player player = event.getEnchanter();
        ItemStack item = event.getItem();
        Map enchantsToAdd = event.getEnchantsToAdd();
        ItemStack lapis = event.getInventory().getItem(1);
        int lapisType = this.getLapisData(lapis);
        int cost = event.whichButton() + 1;
        int level = this.enchantingLevels.get(player)[event.whichButton()];
        if (this.enchantableMaterials.contains(event.getItem().getType()) && !player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            if (lapis == null || lapis.getType() == Material.AIR) {
                Log.error((String)"No lapis in enchanting table");
                event.setCancelled(true);
                return;
            }
            if (lapis.getAmount() < event.whichButton() + 1) {
                Log.error((String)"Not enough lapis to enchant");
                event.setCancelled(true);
                return;
            }
            lapis.setAmount(lapis.getAmount() - (event.whichButton() + 1));
            event.getInventory().setItem(1, lapis);
        }
        double multiplier = (Double)TABLE_CHANCE.get((PropertyHolder)this);
        if (item.getType().equals((Object)Material.BOOK) || item.getType().equals((Object)Material.ENCHANTED_BOOK)) {
            multiplier *= ((Double)TABLE_BOOK_MOD.get((PropertyHolder)this)).doubleValue();
        }
        ArrayList enchantments = Lists.newArrayList(this.enchantManager.getEnchantments().values());
        Collections.shuffle(enchantments);
        for (MythicEnchant enchantment : enchantments) {
            if (!this.isValidEnchantment(enchantment, item)) continue;
            if (!this.enchantmentChanceSuccess(enchantment, lapisType, multiplier)) {
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Failed to roll enchantment {0}, chance {1}", (Object[])new Object[]{enchantment.getKey(), enchantment.getTableChance(lapisType) * multiplier});
                continue;
            }
            if (!this.minimumRequirementsMet(enchantment, lapisType, cost, level)) {
                Log.error((String)"Failed to meet minimum requirements for enchantment {0}", (Object[])new Object[]{enchantment.getKey()});
                continue;
            }
            AtomicBoolean anyConflicts = new AtomicBoolean(false);
            enchantsToAdd.forEach((enchant, integer) -> {
                if (enchantment.conflictsWith(enchantsToAdd.keySet())) {
                    anyConflicts.set(true);
                }
                if (enchant.conflictsWith(enchantment.getBukkitEnchantment())) {
                    anyConflicts.set(true);
                }
            });
            if (anyConflicts.get()) {
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Failed to meet conflict requirements for enchantment {0}", (Object[])new Object[]{enchantment.getKey()});
                continue;
            }
            int enchLevel = this.getEnchantmentLevel(enchantment, cost, level, lapisType);
            enchantsToAdd.put(enchantment.getBukkitEnchantment(), enchLevel);
            int enchantCap = this.maxEnchants.getOrDefault(lapisType, 5);
            if (enchantCap > 0 && enchantsToAdd.size() >= enchantCap) break;
            double probabilityReduction = (Double)TABLE_PER_ENCH_MOD.get((PropertyHolder)this);
            if (!(probabilityReduction > 0.0)) continue;
            multiplier *= probabilityReduction;
        }
        enchantsToAdd.forEach(event.getEnchantsToAdd()::putIfAbsent);
        if (this.enchantableMaterials.contains(event.getItem().getType())) {
            event.getEnchantsToAdd().put(VolatileEnchantment.UNBREAKING, level);
            this.enchantingLevels.remove(player);
        }
        Schedulers.sync().runLater(() -> {
            ItemStack enchantable = event.getInventory().getItem(0);
            if (enchantable == null || !enchantable.hasItemMeta()) {
                return;
            }
            event.getEnchantsToAdd().forEach((enchantment, lvl) -> {
                Optional<MythicEnchant> maybeMythicEnchant = ((MythicEnchants)this.getPlugin()).getEnchantManager().toMythicEnchantment((Enchantment)enchantment);
                if (maybeMythicEnchant.isPresent()) {
                    MythicEnchant mythicEnchant = maybeMythicEnchant.get();
                    MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Applying enchant {0} level {1}", (Object[])new Object[]{enchantment.getKey(), lvl});
                    this.enchantManager.applyToItem(enchantable, mythicEnchant, (int)lvl);
                }
            });
            event.getInventory().setItem(0, enchantable);
        }, 1L);
    }

    public void prepareEnchants(PrepareItemEnchantEvent event) {
        if (!this.enchantableMaterials.contains(event.getItem().getType())) {
            this.saveEnchantmentLevels(event);
            return;
        }
        int maxLevel = this.maxLevelEnchantingTable.getOrDefault(this, 30);
        try {
            event.getOffers()[0].setCost(Numbers.max((int)event.getOffers()[0].getCost(), (int)maxLevel));
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        int bookshelfBonus = Numbers.clamp((int)event.getEnchantmentBonus(), (int)1, (int)15);
        int[] enchantLevels = this.calculateEnchantLevels(bookshelfBonus, maxLevel);
        int[] offerLevels = this.calculateOfferLevels(enchantLevels);
        EnchantmentOffer[] offers = new EnchantmentOffer[]{new EnchantmentOffer(this.fakeIrregularEnchant, offerLevels[0], enchantLevels[0]), new EnchantmentOffer(this.fakeIrregularEnchant, offerLevels[1], enchantLevels[1]), new EnchantmentOffer(this.fakeIrregularEnchant, offerLevels[2], enchantLevels[2])};
        for (int i = 0; i < offers.length; ++i) {
            event.getOffers()[i] = offers[i];
        }
        this.saveEnchantmentLevels(event);
    }

    private int[] calculateEnchantLevels(int bookshelfBonus, int maxLevel) {
        double baseLevel = Math.floor((double)bookshelfBonus / 2.0) + (double)Numbers.randomInt((int)0, (int)bookshelfBonus) + (double)Numbers.randomInt((int)1, (int)8);
        int levelMod = (int)Math.ceil((double)maxLevel / 30.0);
        int enchantLevel1 = (int)Math.ceil(Math.max(baseLevel / 3.0, 1.0)) * levelMod;
        int enchantLevel2 = (int)(baseLevel * 2.0 / 3.0 + 1.0) * levelMod;
        int enchantLevel3 = Numbers.min((int)((int)Math.max(baseLevel, (double)(bookshelfBonus * 2)) * levelMod), (int)maxLevel);
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchanting level calcs:", (Object[])new Object[0]);
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment base level {0}", (Object[])new Object[]{baseLevel});
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment level 1 {0}", (Object[])new Object[]{enchantLevel1});
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment level 2 {0}", (Object[])new Object[]{enchantLevel2});
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment level 3 {0}", (Object[])new Object[]{enchantLevel3});
        return new int[]{enchantLevel1, enchantLevel2, enchantLevel3};
    }

    private int[] calculateOfferLevels(int[] enchantLevels) {
        boolean offerLevel1 = true;
        int offerLevel2 = enchantLevels[1] < 15 ? 1 : Numbers.randomInt((int)2, (int)3);
        int offerLevel3 = (int)Math.ceil((double)enchantLevels[2] / 10.0);
        return new int[]{1, offerLevel2, offerLevel3};
    }

    private boolean isValidEnchantment(MythicEnchant enchantmentToValidate, ItemStack potentialItemToEnchant) {
        if (!enchantmentToValidate.isEnabled()) {
            return false;
        }
        if (enchantmentToValidate.getRarity() == null) {
            return false;
        }
        return enchantmentToValidate.canEnchantItem(potentialItemToEnchant);
    }

    private boolean enchantmentChanceSuccess(MythicEnchant enchantmentToRoll, int lapisType, double multiplier) {
        double chance;
        double check = Numbers.randomDouble();
        return check < (chance = enchantmentToRoll.getTableChance(lapisType) * multiplier);
    }

    private boolean minimumRequirementsMet(MythicEnchant enchantmentToCheck, int lapisType, int minimumLapisCost, int minimumLevel) {
        if (enchantmentToCheck.getTableMinimumCost(lapisType) > minimumLapisCost) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment {0} failed to meet minimum cost requirements", (Object[])new Object[]{enchantmentToCheck.getKey()});
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment {0} minimum cost {1}, player cost {2}", (Object[])new Object[]{enchantmentToCheck.getKey(), enchantmentToCheck.getTableMinimumCost(lapisType), minimumLapisCost});
            return false;
        }
        if (enchantmentToCheck.getTableMinimumLevel(lapisType) > minimumLevel) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment {0} failed to meet minimum level requirements", (Object[])new Object[]{enchantmentToCheck.getKey()});
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment {0} minimum level {1}, player level {2}", (Object[])new Object[]{enchantmentToCheck.getKey(), enchantmentToCheck.getTableMinimumLevel(lapisType), minimumLevel});
            return false;
        }
        return true;
    }

    private int getLapisData(ItemStack lapis) {
        int lapisType = lapis != null && lapis.hasItemMeta() && lapis.getItemMeta().hasCustomModelData() ? lapis.getItemMeta().getCustomModelData() : 0;
        return lapisType;
    }

    private int getEnchantmentLevel(MythicEnchant enchantment, int cost, int level, int lapisType) {
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment test about to begin", (Object[])new Object[0]);
        int enchantMinLevel = enchantment.getTableMinimumLevel(lapisType);
        int enchantMinCost = enchantment.getTableMinimumCost(lapisType);
        double costRatio = (double)enchantMinCost / (double)cost;
        double levelRatio = (double)enchantMinLevel / (double)level;
        try {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment cost {0}, enchantment min cost {1}", (Object[])new Object[]{cost, enchantMinCost});
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment level {0}, enchantment min level {1}", (Object[])new Object[]{level, enchantMinLevel});
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment cost ratio {0}", (Object[])new Object[]{costRatio});
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment level ratio {0}", (Object[])new Object[]{levelRatio});
            double modifier = Numbers.triangularDistribution((double)0.0, (double)1.0, (double)(1.0 - (costRatio + levelRatio) / 2.0));
            int enchantLevel3 = (int)Math.ceil((double)enchantment.getMaxLevel() * modifier);
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment Modifier {0}", (Object[])new Object[]{modifier});
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment level {0}", (Object[])new Object[]{enchantLevel3});
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment max level {0}", (Object[])new Object[]{enchantment.getMaxLevel()});
            return Numbers.min((int)enchantLevel3, (int)enchantment.getMaxLevel());
        }
        catch (ArithmeticException e) {
            Log.error((String)"Arithmetic Exception: {0}", (Object[])new Object[]{e.getMessage()});
            Log.error((String)("Arithmetic Exception, showing applicable values: " + cost + " " + enchantMinLevel + " " + String.valueOf(this.maxLevelEnchantingTable.getOrDefault(lapisType, 30)) + " " + enchantment.getMaxTableLevel()));
            return 1;
        }
    }

    private void saveEnchantmentLevels(PrepareItemEnchantEvent event) {
        ArrayList<Integer> enchantmentLevelList = new ArrayList<Integer>();
        for (EnchantmentOffer offer : event.getOffers()) {
            if (offer == null) continue;
            enchantmentLevelList.add(offer.getCost());
        }
        this.enchantingLevels.put(event.getEnchanter(), enchantmentLevelList.stream().mapToInt(i -> i).toArray());
    }

    public String getPropertyNode() {
        return "Configuration.EnchantingTable";
    }

    public Map<Integer, Integer> getMaxLevelEnchantingTable() {
        return this.maxLevelEnchantingTable;
    }

    public Map<Integer, Integer> getMaxEnchants() {
        return this.maxEnchants;
    }
}

