/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.skills;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitTriggerMetadata;
import io.lumine.mythic.bukkit.events.MythicTriggerEvent;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.events.extra.ArmorEquipEvent;
import io.lumine.mythic.bukkit.utils.events.extra.ArmorType;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersion;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.constants.ItemType;
import io.lumine.mythicenchants.enchants.MythicEnchant;
import io.lumine.mythicenchants.enchants.custom.CustomEnchantment;
import io.lumine.mythicenchants.enchants.properties.EnchantSlot;
import io.lumine.mythicenchants.enchants.skills.AppliedEnchant;
import io.lumine.mythicenchants.enchants.skills.triggers.EnchantedItemTriggers;
import io.lumine.mythicenchants.profiles.EnchantsProfile;
import io.lumine.mythicenchants.profiles.EnchantsProfileManager;
import java.util.Map;
import java.util.function.Consumer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public class CustomSkillHandler
extends ReloadableModule<MythicEnchants> {
    private EnchantsProfileManager profileManager;
    private Consumer<PlayerDropItemEvent> TRIGGER_DROP_ITEM = event -> this.getProfile(event.getPlayer()).parseWeapons();

    public CustomSkillHandler(MythicEnchants mythicEnchants) {
        super((LuminePlugin)mythicEnchants, false);
        Log.info((String)"Loading Custom Skill Handler");
        this.load(mythicEnchants);
    }

    public void load(MythicEnchants mythicEnchants) {
        this.profileManager = mythicEnchants.getProfileManager();
        this.initSkillTriggerListeners();
    }

    private void initSkillTriggerListeners() {
        Events.subscribe(MythicTriggerEvent.class, (EventPriority)EventPriority.HIGHEST).handler(this::onTrigger).bindWith((TerminableConsumer)this);
        Events.subscribe(PlayerJoinEvent.class).handler(this::onTriggerJoin).bindWith((TerminableConsumer)this);
        Events.subscribe(PlayerRespawnEvent.class).handler(event -> {
            this.onTriggerRespawn((PlayerRespawnEvent)event);
            this.profileManager.updatePlayerArmorDelayed(event.getPlayer());
        }).bindWith((TerminableConsumer)this);
        Events.subscribe(PlayerDeathEvent.class, (EventPriority)EventPriority.HIGH).handler(this::onTriggerDeath).bindWith((TerminableConsumer)this);
        Events.subscribe(EntityDamageEvent.class, (EventPriority)EventPriority.HIGHEST).handler(this::onTriggerDamaged).bindWith((TerminableConsumer)this);
        Events.subscribe(PlayerInteractEvent.class, (EventPriority)EventPriority.HIGHEST).handler(event -> {
            this.onTriggerInteract((PlayerInteractEvent)event);
            if (ItemType.ARMOR.getTypeMaterials().contains(event.getPlayer().getItemInHand().getType())) {
                this.profileManager.updatePlayerArmorDelayed(event.getPlayer());
            }
            if (event.getAction() == Action.PHYSICAL) {
                this.profileManager.updatePlayerWeapon(event.getPlayer());
            }
        }).bindWith((TerminableConsumer)this);
        Events.subscribe(PlayerInteractAtEntityEvent.class, (EventPriority)EventPriority.HIGHEST).handler(this::onTriggerInteractEntity).bindWith((TerminableConsumer)this);
        Events.subscribe(PlayerToggleSneakEvent.class).handler(this::onTriggerSneak).bindWith((TerminableConsumer)this);
        Events.subscribe(EntityShootBowEvent.class, (EventPriority)EventPriority.HIGHEST).handler(this::onTriggerBowShoot).bindWith((TerminableConsumer)this);
        Events.subscribe(PlayerFishEvent.class, (EventPriority)EventPriority.HIGHEST).handler(this::onTriggerFish).bindWith((TerminableConsumer)this);
        Events.subscribe(EntityDeathEvent.class, (EventPriority)EventPriority.HIGH).handler(this::onTriggerKill).bindWith((TerminableConsumer)this);
        Events.subscribe(BlockPlaceEvent.class, (EventPriority)EventPriority.HIGH).handler(this::onTriggerBlockPlace).bindWith((TerminableConsumer)this);
        Events.subscribe(BlockBreakEvent.class, (EventPriority)EventPriority.HIGH).handler(this::onTriggerBlockBreak).bindWith((TerminableConsumer)this);
        Events.subscribe(ArmorEquipEvent.class, (EventPriority)EventPriority.MONITOR).handler(event -> this.onArmorEquip((ArmorEquipEvent)event)).bindWith((TerminableConsumer)this);
        Events.subscribe(PlayerDropItemEvent.class).handler(this.TRIGGER_DROP_ITEM).bindWith((TerminableConsumer)this);
        Events.subscribe(PlayerItemBreakEvent.class, (EventPriority)EventPriority.HIGH).handler(event -> this.profileManager.updatePlayerArmorDelayed(event.getPlayer())).bindWith((TerminableConsumer)this);
        Events.subscribe(PlayerSwapHandItemsEvent.class, (EventPriority)EventPriority.HIGH).handler(event -> this.profileManager.updatePlayerArmorDelayed(event.getPlayer())).bindWith((TerminableConsumer)this);
        Events.subscribe(PlayerItemHeldEvent.class).handler(event -> this.profileManager.updatePlayerWeaponDelayed(event.getPlayer())).bindWith((TerminableConsumer)this);
        Events.subscribe(PlayerDropItemEvent.class).handler(event -> this.profileManager.clearPlayerWeaponDelayed(event.getPlayer())).bindWith((TerminableConsumer)this);
        Events.subscribe(EntityPickupItemEvent.class).handler(event -> {
            Player player;
            LivingEntity patt0$temp = event.getEntity();
            if (patt0$temp instanceof Player && ((player = (Player)patt0$temp).getInventory().getItemInHand() == null || player.getInventory().getItemInHand().getType() == Material.AIR)) {
                this.profileManager.updatePlayerWeaponDelayed((Player)event.getEntity());
            }
        }).bindWith((TerminableConsumer)this);
        this.subscribeInventoryEvents();
    }

    public void unload() {
    }

    private EnchantsProfile getProfile(Player player) {
        return (EnchantsProfile)((MythicEnchants)this.getPlugin()).getProfileManager().getProfile(player);
    }

    private void onTriggerJoin(PlayerJoinEvent playerJoinEvent) {
        ((MythicEnchants)this.getPlugin()).getProfileManager().awaitProfile(playerJoinEvent.getPlayer()).thenAcceptSync(maybeProfile -> maybeProfile.ifPresent(profile -> {
            profile.parseEquipment();
            profile.runSkills(SkillTriggers.SPAWN, (AbstractEntity)BukkitAdapter.adapt((Player)playerJoinEvent.getPlayer()));
            profile.runSkills(SkillTriggers.JOIN, (AbstractEntity)BukkitAdapter.adapt((Player)playerJoinEvent.getPlayer()));
        }));
    }

    private void onTriggerRespawn(PlayerRespawnEvent event) {
        EnchantsProfile profile = this.getProfile(event.getPlayer());
        profile.runSkills(SkillTriggers.SPAWN, (AbstractEntity)BukkitAdapter.adapt((Player)event.getPlayer()));
        profile.runSkills(SkillTriggers.RESPAWN, (AbstractEntity)BukkitAdapter.adapt((Player)event.getPlayer()));
    }

    private void onTriggerDeath(PlayerDeathEvent event) {
        Projectile proj;
        ProjectileSource ps;
        EntityDamageEvent entityDamageEvent;
        Player killed = event.getEntity();
        Player killer = killed.getKiller();
        if (killer == null && (entityDamageEvent = event.getEntity().getLastDamageCause()) != null && !entityDamageEvent.isCancelled() && entityDamageEvent instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent byEntityEvent = (EntityDamageByEntityEvent)entityDamageEvent;
            killer = byEntityEvent.getDamager();
        }
        if (killer instanceof Projectile && (ps = (proj = (Projectile)killer).getShooter()) instanceof LivingEntity) {
            killer = (Entity)ps;
        }
        if (killer instanceof Player) {
            Player playerKiller = killer;
            EnchantsProfile killerProfile = this.getProfile(playerKiller);
            killerProfile.runSkills(SkillTriggers.KILLPLAYER, (AbstractEntity)BukkitAdapter.adapt((Player)killed));
        }
        EnchantsProfile killedProfile = this.getProfile(killed);
        killedProfile.runSkills(SkillTriggers.DEATH, BukkitAdapter.adapt((Entity)killer));
    }

    private void onTrigger(MythicTriggerEvent event) {
        if (event.isCancelled()) {
            return;
        }
        SkillMetadata meta = event.getSkillMetadata();
        AbstractEntity player = meta.getCaster().getEntity();
        EnchantsProfile profile = (EnchantsProfile)((MythicEnchants)this.getPlugin()).getProfileManager().getProfile((Player)player.getBukkitEntity());
        profile.runSkills(event.getParent(), event.getSkillMetadata());
    }

    private void onTriggerDamaged(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player) {
            boolean c;
            Player p = (Player)e.getEntity();
            EnchantsProfile gs = this.getProfile(p);
            if (!(e instanceof EntityDamageByEntityEvent) && (c = gs.runSkills(SkillTriggers.DAMAGED, BukkitAdapter.adapt((Location)p.getLocation()), (AbstractEntity)BukkitAdapter.adapt((Player)p), meta -> BukkitTriggerMetadata.apply((SkillMetadata)meta, (EntityDamageEvent)e)))) {
                e.setCancelled(true);
            }
        }
    }

    private void onTriggerInteract(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        EnchantsProfile gs = this.getProfile(e.getPlayer());
        switch (e.getAction()) {
            case LEFT_CLICK_AIR: 
            case LEFT_CLICK_BLOCK: {
                boolean c = gs.runSkills(SkillTriggers.SWING, gs.getEntity());
                if (!c) break;
                e.setCancelled(true);
                break;
            }
            case RIGHT_CLICK_AIR: 
            case RIGHT_CLICK_BLOCK: {
                if (player.getInventory().getItemInMainHand() != null && player.getInventory().getItemInMainHand().getType() != Material.AIR && e.getHand() == EquipmentSlot.HAND) {
                    boolean cc = gs.runSkills(SkillTriggers.USE, gs.getEntity());
                    if (!cc) break;
                    e.setCancelled(true);
                    break;
                }
                try {
                    boolean ccc = gs.runSkills(SkillTriggers.RIGHTCLICK, gs.getEntity());
                    if (ccc) {
                        e.setCancelled(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            default: {
                return;
            }
        }
    }

    private void onTriggerInteractEntity(PlayerInteractAtEntityEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        EnchantsProfile gs = this.getProfile(player);
        boolean c = gs.runSkills(SkillTriggers.INTERACT, BukkitAdapter.adapt((Entity)event.getRightClicked()));
        if (c) {
            event.setCancelled(true);
        }
    }

    private void onTriggerSneak(PlayerToggleSneakEvent event) {
        if (!event.getPlayer().isSneaking()) {
            this.getProfile(event.getPlayer()).runSkills(SkillTriggers.CROUCH, (AbstractEntity)BukkitAdapter.adapt((Player)event.getPlayer()));
        } else {
            this.getProfile(event.getPlayer()).runSkills(SkillTriggers.UNCROUCH, (AbstractEntity)BukkitAdapter.adapt((Player)event.getPlayer()));
        }
    }

    private void onTriggerBowShoot(EntityShootBowEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        EnchantsProfile caster = this.getProfile(player);
        boolean c = caster.runSkills(SkillTriggers.SHOOT, BukkitAdapter.adapt((Location)player.getLocation()), (AbstractEntity)BukkitAdapter.adapt((Player)player), meta -> {
            meta.getVariables().putFloat("bow-tension", event.getForce());
            meta.setPower(event.getForce());
        });
        if (c) {
            event.setCancelled(true);
        }
    }

    private void onTriggerFish(PlayerFishEvent event) {
        if (ServerVersion.isBeforeOrEq((MinecraftVersion)MinecraftVersions.v1_12)) {
            return;
        }
        Player player = event.getPlayer();
        EnchantsProfile caster = this.getProfile(player);
        AbstractEntity trigger = event.getCaught() != null ? BukkitAdapter.adapt((Entity)event.getCaught()) : null;
        AbstractLocation origin = event.getHook() != null ? BukkitAdapter.adapt((Location)event.getHook().getLocation()) : (event.getCaught() != null ? BukkitAdapter.adapt((Location)event.getCaught().getLocation()) : BukkitAdapter.adapt((Location)player.getLocation()));
        boolean c = caster.runSkills(switch (event.getState()) {
            case PlayerFishEvent.State.FISHING -> SkillTriggers.FISH;
            case PlayerFishEvent.State.BITE -> SkillTriggers.FISH_BITE;
            case PlayerFishEvent.State.CAUGHT_ENTITY -> SkillTriggers.FISH_CATCH_ENTITY;
            case PlayerFishEvent.State.CAUGHT_FISH -> SkillTriggers.FISH_CATCH_FISH;
            case PlayerFishEvent.State.FAILED_ATTEMPT -> SkillTriggers.FISH_FAIL;
            case PlayerFishEvent.State.IN_GROUND -> SkillTriggers.FISH_GROUND;
            default -> SkillTriggers.FISH_REEL;
        }, origin, trigger);
        if (c) {
            event.setCancelled(true);
        }
    }

    private void onTriggerKill(EntityDeathEvent event) {
        Projectile proj;
        ProjectileSource ps;
        EntityDamageEvent entityDamageEvent;
        LivingEntity killed = event.getEntity();
        Player killer = killed.getKiller();
        if (killer == null && (entityDamageEvent = event.getEntity().getLastDamageCause()) != null && !entityDamageEvent.isCancelled() && entityDamageEvent instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent byEntityEvent = (EntityDamageByEntityEvent)entityDamageEvent;
            killer = byEntityEvent.getDamager();
        }
        if (killer instanceof Projectile && (ps = (proj = (Projectile)killer).getShooter()) instanceof Entity) {
            killer = (Entity)ps;
        }
        if (killer instanceof Player) {
            Player playerKiller = killer;
            EnchantsProfile killerProfile = this.getProfile(playerKiller);
            killerProfile.runSkills(SkillTriggers.KILL, BukkitAdapter.adapt((Entity)killed));
        }
    }

    private void onTriggerBlockPlace(BlockPlaceEvent event) {
        AbstractLocation origin;
        Player player = event.getPlayer();
        EnchantsProfile caster = this.getProfile(player);
        boolean b = caster.runSkills(SkillTriggers.BLOCK_PLACE, origin = BukkitAdapter.adapt((Location)event.getBlock().getLocation()), caster.getEntity());
        if (b) {
            event.setCancelled(true);
        }
    }

    private void onTriggerBlockBreak(BlockBreakEvent event) {
        AbstractLocation origin;
        Player player = event.getPlayer();
        EnchantsProfile caster = this.getProfile(player);
        boolean b = caster.runSkills(SkillTriggers.BLOCK_BREAK, origin = BukkitAdapter.adapt((Location)event.getBlock().getLocation()), caster.getEntity());
        if (b) {
            event.setCancelled(true);
        }
    }

    private void onArmorEquip(ArmorEquipEvent event) {
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Handling Armor Equip/Unequip for: {0}", (Object[])new Object[]{event.getPlayer().getName()});
        SkillTrigger<?>[] trigger = this.determineArmorTrigger(event);
        if (trigger[0] != null) {
            this.equipEventDebugMessage("Armor Un-Equip Trigger executed", event);
            this.handleArmorEquipEnchants(trigger[0], event);
            this.handleNonProfileEnchantedItems(EnchantedItemTriggers.getEquipmentTrigger(trigger[0]), event.getOldArmorPiece(), event);
        }
        if (trigger[1] != null) {
            this.equipEventDebugMessage("Armor Equip Trigger executed", event);
            this.handleArmorEquipEnchants(trigger[1], event);
            this.handleNonProfileEnchantedItems(EnchantedItemTriggers.getEquipmentTrigger(trigger[1]), event.getNewArmorPiece(), event);
        }
    }

    private void equipEventDebugMessage(String eventExecutionMessage, ArmorEquipEvent event) {
        try {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"{0}: Old Armor Piece: {1} , New Armor Piece: {2}", (Object[])new Object[]{eventExecutionMessage, event.getOldArmorPiece().getType().name(), event.getNewArmorPiece().getType().name()});
        }
        catch (NullPointerException e) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"{0} with null error: Old Armor Piece: {1} , New Armor Piece: {2}", (Object[])new Object[]{eventExecutionMessage, event.getOldArmorPiece(), event.getNewArmorPiece()});
        }
    }

    private SkillTrigger<?>[] determineArmorTrigger(ArmorEquipEvent event) {
        SkillTrigger[] skillTriggers = new SkillTrigger[2];
        if (event.getOldArmorPiece() != null && event.getOldArmorPiece().getType() != Material.AIR) {
            skillTriggers[0] = SkillTriggers.ARMOR_UNEQUIP;
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Armor Un-Equip Trigger detected", (Object[])new Object[0]);
        }
        if (event.getNewArmorPiece() != null && event.getNewArmorPiece().getType() != Material.AIR) {
            skillTriggers[1] = SkillTriggers.ARMOR_EQUIP;
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Armor Equip Trigger detected", (Object[])new Object[0]);
        }
        return skillTriggers;
    }

    private void handleArmorEquipEnchants(SkillTrigger<?> trigger, ArmorEquipEvent event) {
        EnchantsProfile profile = this.getProfile(event.getPlayer());
        profile.runSkills(trigger, (AbstractEntity)BukkitAdapter.adapt((Player)event.getPlayer()));
    }

    private void handleNonProfileEnchantedItems(SkillTrigger<?> trigger, ItemStack armor, ArmorEquipEvent event) {
        String armorName = PlainTextComponentSerializer.plainText().serialize(armor.displayName());
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Handling Non-Profile Enchanted Item {0}", (Object[])new Object[]{armorName});
        Map<MythicEnchant, Integer> enchants = ((MythicEnchants)this.plugin).getEnchantManager().getMythicEnchants(armor);
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Number of enchants found on item {0}: {1}", (Object[])new Object[]{armorName, enchants.size()});
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchants found on item {0}:", (Object[])new Object[]{armorName});
        enchants.keySet().forEach(key -> MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"- {0}", (Object[])new Object[]{key.getName()}));
        if (enchants.isEmpty()) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"No enchants found on item {0}", (Object[])new Object[]{armor.displayName()});
            return;
        }
        for (MythicEnchant ench : enchants.keySet()) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.TRIGGER, (String)"Enchant {0} found on item {1}", (Object[])new Object[]{ench.getName(), armorName});
            if (!(ench instanceof CustomEnchantment)) continue;
            CustomEnchantment customEnchantment = (CustomEnchantment)ench;
            if (!customEnchantment.hasMechanics(trigger)) {
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.TRIGGER, (String)"No skills found for trigger {0} on enchant {1} on item {2}", (Object[])new Object[]{trigger.name(), customEnchantment.getName(), armorName});
                continue;
            }
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.TRIGGER, (String)"Executing enchant {0} on item {1}", (Object[])new Object[]{customEnchantment.getName(), armor.displayName()});
            this.runSkills(armor.clone(), trigger, event, customEnchantment, enchants.get(customEnchantment));
        }
    }

    private void runSkills(ItemStack armorCopy, SkillTrigger<?> trigger, ArmorEquipEvent event, CustomEnchantment customEnchantment, int level) {
        Schedulers.async().run(() -> {
            EnchantsProfile profile = this.getProfile(event.getPlayer());
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Profile: {0} obtained, attempting to create applied enchantment", (Object[])new Object[]{profile.getPlayerData().getName()});
            AppliedEnchant appliedEnchantment = new AppliedEnchant(profile, customEnchantment, level, EnchantSlot.getSlot(armorCopy.getType().name()), armorCopy.getType());
            AbstractLocation origin = BukkitAdapter.adapt((Location)event.getPlayer().getLocation());
            appliedEnchantment.runSkills((SkillCaster)profile.getPlayerData(), trigger, origin, profile.getEntity());
        });
    }

    private void subscribeInventoryEvents() {
        Events.subscribe(InventoryInteractEvent.class, (EventPriority)EventPriority.HIGH).handler(event -> this.profileManager.updatePlayerArmorDelayed((Player)event.getWhoClicked())).bindWith((TerminableConsumer)this);
        Events.subscribe(InventoryCloseEvent.class, (EventPriority)EventPriority.HIGH).handler(event -> this.profileManager.updatePlayerArmor((Player)event.getPlayer())).bindWith((TerminableConsumer)this);
        Events.subscribe(InventoryClickEvent.class).handler(event -> {
            if (event.getSlotType() == InventoryType.SlotType.ARMOR || event.getSlotType() == InventoryType.SlotType.QUICKBAR || event.getClick() == ClickType.SHIFT_LEFT) {
                this.profileManager.updatePlayerArmorDelayed((Player)event.getWhoClicked());
            }
        }).bindWith((TerminableConsumer)this);
        Events.subscribe(InventoryDragEvent.class).handler(event -> {
            int[] slotsToCheck;
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.EVENT, (String)"Inventory Drag Event Triggered", (Object[])new Object[0]);
            int[] nArray = slotsToCheck = event.getInventorySlots().stream().filter(integer -> integer <= 8 && integer >= 5).mapToInt(Integer::intValue).toArray();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer slot = nArray[i];
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.EVENT, (String)"Armor Equip Event created from drag event from slot {0}", (Object[])new Object[]{slot});
                ArmorEquipEvent armorEquipEvent = new ArmorEquipEvent((Player)event.getWhoClicked(), ArmorEquipEvent.EquipMethod.DRAG, ArmorType.matchType((ItemStack)((ItemStack)event.getNewItems().get(slot))), event.getInventory().getItem(slot.intValue()), (ItemStack)event.getNewItems().get(slot));
                Bukkit.getPluginManager().callEvent((Event)armorEquipEvent);
            }
        });
    }
}

