/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.properties.rarity;

import com.google.common.collect.Maps;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.config.properties.types.DoubleProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringListProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythicenchants.config.Scope;
import io.lumine.mythicenchants.enchants.properties.rarity.config.EnchantingTableConfigLine;
import io.lumine.mythicenchants.enchants.properties.rarity.config.VillagerConfigLine;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Villager;

public class EnchantRarity
implements PropertyHolder {
    private static final StringProp DISPLAY = Property.String((Object)((Object)Scope.RARITIES), (String)"Display");
    private static final StringProp COLOR = Property.String((Object)((Object)Scope.RARITIES), (String)"Color", (String)"GRAY");
    private static final StringListProp SOURCES = Property.StringList((Object)((Object)Scope.RARITIES), (String)"Sources");
    private static final DoubleProp CHANCE_LOOT = Property.Double((Object)((Object)Scope.RARITIES), (String)"Loot_Chance");
    private final String key;
    private String display;
    private TextColor color;
    private Map<Integer, Double> chanceEnchantingTable = Maps.newConcurrentMap();
    private Map<Villager.Profession, Double> chanceVillagers = Maps.newConcurrentMap();
    private double chanceLoot;
    private Map<Integer, Integer> minCostEnchantingTable = Maps.newConcurrentMap();
    private Map<Integer, Integer> minLevelEnchantingTable = Maps.newConcurrentMap();

    public EnchantRarity(String key) {
        this.key = key;
        this.load();
    }

    private void load() {
        this.display = (String)DISPLAY.get((PropertyHolder)this);
        TextColor textColor = this.color = ((String)COLOR.get((PropertyHolder)this)).startsWith("#") ? TextColor.fromHexString((String)((String)COLOR.get((PropertyHolder)this))) : (TextColor)NamedTextColor.NAMES.value((Object)((String)COLOR.get((PropertyHolder)this)).toUpperCase());
        if (this.color == null) {
            this.color = NamedTextColor.GRAY;
        }
        block10: for (String line : (List)SOURCES.get((PropertyHolder)this)) {
            switch (MythicBukkit.inst().getConfiguration().createLineConfig(line).getKey().toLowerCase()) {
                case "enchantingtable": {
                    this.handleEnchantingTableConfigLine(line);
                    continue block10;
                }
                case "villager": {
                    this.handleVillagerConfigLine(line);
                    continue block10;
                }
                case "dungeon": {
                    MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Dungeon Config Line: {0}", (Object[])new Object[]{line});
                    this.handleDungeonConfigLine(line);
                    continue block10;
                }
            }
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Unknown Config Line: {0}", (Object[])new Object[]{line});
        }
        this.chanceLoot = (Double)CHANCE_LOOT.get((PropertyHolder)this) * 100.0;
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Number of Enchanting Table chance properties loaded: {0}", (Object[])new Object[]{this.chanceEnchantingTable.size()});
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Number of Villager chance properties loaded: {0}", (Object[])new Object[]{this.chanceVillagers.size()});
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Chance of Dungeon Loot providing enchantment: {0}%", (Object[])new Object[]{this.chanceLoot});
    }

    private void handleVillagerConfigLine(String line) {
        VillagerConfigLine villagerConfigLine = new VillagerConfigLine(line);
        if (villagerConfigLine.getProfession() == Villager.Profession.NONE) {
            return;
        }
        this.chanceVillagers.put(villagerConfigLine.getProfession(), villagerConfigLine.getChance());
    }

    private void handleEnchantingTableConfigLine(String line) {
        EnchantingTableConfigLine enchantingTableConfigLine = new EnchantingTableConfigLine(line);
        this.minCostEnchantingTable.put(enchantingTableConfigLine.getEnchantLevel().get(), enchantingTableConfigLine.getMinCost().get());
        this.minLevelEnchantingTable.put(enchantingTableConfigLine.getEnchantLevel().get(), enchantingTableConfigLine.getMinTableLevel().get());
        this.chanceEnchantingTable.put(enchantingTableConfigLine.getEnchantLevel().get(), Double.valueOf(Math.round(enchantingTableConfigLine.getEnchantChance().get() * 100.0f)));
    }

    private void handleDungeonConfigLine(String line) {
    }

    public String getPropertyNode() {
        return this.key;
    }

    public String getDisplay() {
        return this.display;
    }

    public TextColor getColor() {
        return this.color;
    }

    public Map<Integer, Double> getChanceEnchantingTable() {
        return this.chanceEnchantingTable;
    }

    public Map<Villager.Profession, Double> getChanceVillagers() {
        return this.chanceVillagers;
    }

    public double getChanceLoot() {
        return this.chanceLoot;
    }

    public Map<Integer, Integer> getMinCostEnchantingTable() {
        return this.minCostEnchantingTable;
    }

    public Map<Integer, Integer> getMinLevelEnchantingTable() {
        return this.minLevelEnchantingTable;
    }
}

