/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.loot.handlers;

import io.lumine.mythicenchants.enchants.EnchantManager;
import io.lumine.mythicenchants.enchants.MythicEnchant;
import io.lumine.mythicenchants.enchants.loot.handlers.LootEventHandler;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.ItemStack;

public class LootGenerateHandler
implements LootEventHandler {
    private final EnchantManager enchantManager;
    private MythicEnchant enchantment;
    private final LootGenerateEvent lootEvent;
    private ItemStack enchantedItem;
    private final ArrayList<ItemStack> lootItems;

    public LootGenerateHandler(LootGenerateEvent lootEvent, EnchantManager enchantManager) {
        this.lootEvent = lootEvent;
        this.lootItems = new ArrayList(lootEvent.getLoot());
        this.enchantManager = enchantManager;
    }

    @Override
    public void addEnchantedItem() {
        if (this.enchantedItem == null) {
            return;
        }
        this.lootItems.add(this.enchantedItem);
        this.lootEvent.setLoot(this.lootItems);
    }

    @Override
    public boolean requirementsMet() {
        return true;
    }

    @Override
    public double getLootChance() {
        return this.enchantment.getRarityCategory().getChanceLoot();
    }

    @Override
    public void setEnchantedLoot(MythicEnchant enchantment, int appliedLevel, Random randomIntGenerator) {
        this.enchantment = enchantment;
        this.enchantedItem = this.setEnchantedItem(appliedLevel, randomIntGenerator);
    }

    @Override
    public String getEventName() {
        return this.lootEvent.getEventName();
    }

    private ItemStack setEnchantedItem(int appliedLevel, Random randomIntGenerator) {
        ItemStack selectedItem = null;
        try {
            for (ItemStack item : this.lootItems) {
                if (item.getType() != Material.ENCHANTED_BOOK && !this.enchantment.getEnchantableMaterials().contains(item.getType())) continue;
                this.lootItems.remove(item);
                selectedItem = item;
                break;
            }
            return this.enchantManager.applyToItem(selectedItem, this.enchantment, appliedLevel);
        }
        catch (NullPointerException exception) {
            return null;
        }
    }
}

