/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.hardcoded;

import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.config.properties.types.DoubleProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.LangProp;
import io.lumine.mythic.bukkit.utils.config.properties.types.StringProp;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.config.Scope;
import io.lumine.mythicenchants.enchants.EnchantManager;
import io.lumine.mythicenchants.enchants.MythicEnchant;
import io.lumine.mythicenchants.enchants.properties.EnchantInfo;
import io.lumine.mythicenchants.enchants.properties.EnchantSlot;
import io.lumine.mythicenchants.enchants.properties.EnchantType;
import io.lumine.mythicenchants.profiles.EnchantsProfile;
import java.io.File;
import java.util.function.Consumer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class HardcodedEnchantment
extends MythicEnchant
implements PropertyHolder {
    private static final DoubleProp COOLDOWN = Property.Double((Object)((Object)Scope.NONE), (String)"Cooldown.BaseCooldown", (double)0.0);
    private static final DoubleProp COOLDOWNPER = Property.Double((Object)((Object)Scope.NONE), (String)"Cooldown.CooldownPerLevel", (double)0.0);
    private static final LangProp COOLDOWN_MESSAGE = Property.Lang((Object)((Object)Scope.CONFIG), (String)"Message.CooldownMessage", (String)"{name} is on cooldown for {remaining} seconds.");
    private static final StringProp COOLDOWN_ROUTE = Property.String((Object)((Object)Scope.CONFIG), (String)"Message.Routing", (String)"chat");
    private static final DoubleProp CHANCE = Property.Double((Object)((Object)Scope.NONE), (String)"Chance.BaseChance", (double)0.0);
    private static final DoubleProp CHANCEPER = Property.Double((Object)((Object)Scope.NONE), (String)"Chance.ChancePerLevel", (double)0.0);
    protected final EnchantType enchantType;
    private double cooldown;
    private double cooldownPerLevel;
    private String cooldownMessage;
    private String cooldownRoute;
    private double chance;
    private double chancePerLevel;

    public HardcodedEnchantment(EnchantManager manager, EnchantType enchantType) {
        super(manager, enchantType.get(), enchantType.toString().toUpperCase());
        this.enchantType = enchantType;
        this.load();
    }

    @Override
    public void load() {
        if (new File(MythicEnchants.inst().getDataFolder(), this.enchantType.get() + ".yml").exists()) {
            Log.info((String)("+ Loading " + this.enchantType.get() + ".yml"));
        } else {
            Log.info((String)("+ Generating " + this.enchantType.get() + ".yml"));
            MythicEnchants.inst().saveResource(this.enchantType.get() + ".yml", false);
        }
        this.cooldown = (Double)COOLDOWN.fget(this.getScope(), (PropertyHolder)this);
        this.cooldownPerLevel = (Double)COOLDOWNPER.fget(this.getScope(), (PropertyHolder)this);
        this.cooldownMessage = (String)COOLDOWN_MESSAGE.fget(this.getScope(), (PropertyHolder)this);
        this.cooldownRoute = (String)COOLDOWN_ROUTE.fget(this.getScope(), (PropertyHolder)this);
        this.chance = (Double)CHANCE.fget(this.getScope(), (PropertyHolder)this);
        this.chancePerLevel = (Double)CHANCEPER.fget(this.getScope(), (PropertyHolder)this);
        super.load();
    }

    public void onEquip(Player player, int level) {
    }

    public void onUnequip(Player player, int level) {
    }

    public void initializeEnchant() {
    }

    public void handleCast(EnchantsProfile profile) {
    }

    public void handleOnCooldown(EnchantsProfile profile, EnchantInfo enchantInfo) {
    }

    public boolean checkShouldCast(Player player, EnchantInfo enchantInfo) {
        EnchantsProfile profile = (EnchantsProfile)MythicEnchants.inst().getProfileManager().getProfile(player);
        return this.checkShouldCast(profile, enchantInfo);
    }

    public boolean checkShouldCast(EnchantsProfile profile, EnchantInfo enchantInfo) {
        if (!this.roll(enchantInfo)) {
            return false;
        }
        double cd = this.getCooldown() + this.getCooldownPerLevel() * (double)enchantInfo.getLevel();
        if (profile.isEnchantInCooldownMap(this.getEnchantType()) && profile.isEnchantOnCooldown(this.getEnchantType(), cd)) {
            this.handleOnCooldown(profile, enchantInfo);
            return false;
        }
        this.handleCast(profile);
        return true;
    }

    public void ifEnchantPresent(Entity entity, Consumer<EnchantInfo> consumer) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int level = 0;
        EnchantSlot slot = null;
        for (EnchantSlot checkSlot : this.getApplicableSlots()) {
            int l = checkSlot.getEnchantLevel(player, this.getBukkitEnchantment());
            if (l <= 0) continue;
            slot = checkSlot;
            if (this.getStacksLevels().booleanValue()) {
                level += l;
                continue;
            }
            if (l <= level) continue;
            level = l;
        }
        if (level > 0) {
            consumer.accept(new EnchantInfo(player, level, slot));
        }
    }

    @Override
    public EnchantmentTarget getItemTarget() {
        return EnchantmentTarget.ALL;
    }

    @Override
    public boolean conflictsWith(Enchantment other) {
        return false;
    }

    @Override
    public boolean canEnchantItem(ItemStack item) {
        return false;
    }

    public boolean roll(EnchantInfo enchantInfo) {
        return this.getChance() + this.getChancePerLevel() * (double)enchantInfo.getLevel() >= Numbers.randomDouble();
    }

    @Override
    public String getPropertyNode() {
        return this.getName();
    }

    public void handleCooldownMessage(Player player, EnchantsProfile profile, EnchantInfo enchantInfo) {
        String message = this.cooldownMessage.replace("{name}", this.getName()).replace("{remaining}", String.valueOf(Numbers.round((double)profile.getRemainingCooldown(this.enchantType, this.getCooldown() + this.getCooldownPerLevel() * (double)enchantInfo.getLevel()), (int)2)));
        if (!message.isEmpty()) {
            if (this.cooldownRoute.equalsIgnoreCase("chat")) {
                player.sendMessage(message);
            } else if (this.cooldownRoute.equalsIgnoreCase("actionbar")) {
                // empty if block
            }
        }
    }

    public EnchantType getEnchantType() {
        return this.enchantType;
    }

    public double getCooldown() {
        return this.cooldown;
    }

    public double getCooldownPerLevel() {
        return this.cooldownPerLevel;
    }

    public String getCooldownMessage() {
        return this.cooldownMessage;
    }

    public String getCooldownRoute() {
        return this.cooldownRoute;
    }

    public double getChance() {
        return this.chance;
    }

    public double getChancePerLevel() {
        return this.chancePerLevel;
    }
}

