/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.hardcoded;

import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.config.properties.Property;
import io.lumine.mythic.bukkit.utils.config.properties.PropertyHolder;
import io.lumine.mythic.bukkit.utils.config.properties.types.DoubleProp;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythicenchants.config.Scope;
import io.lumine.mythicenchants.enchants.EnchantManager;
import io.lumine.mythicenchants.enchants.hardcoded.HardcodedEnchantment;
import io.lumine.mythicenchants.enchants.properties.EnchantInfo;
import io.lumine.mythicenchants.enchants.properties.EnchantType;
import io.lumine.mythicenchants.profiles.EnchantsProfile;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class EnderEnchant
extends HardcodedEnchantment {
    private final DoubleProp RADIUS = Property.Double((Object)((Object)Scope.CONFIG), (String)"EnchantmentEffects.Radius", (double)10.0);
    private final DoubleProp RADIUS_Y = Property.Double((Object)((Object)Scope.CONFIG), (String)"EnchantmentEffects.RadiusY", (double)5.0);
    private double radius;
    private double radiusY;

    public EnderEnchant(EnchantManager manager) {
        super(manager, EnchantType.ENDER);
        this.initializeEnchant();
    }

    @Override
    public void initializeEnchant() {
        this.radius = (Double)this.RADIUS.fget(this.getScope(), (PropertyHolder)this);
        this.radiusY = (Double)this.RADIUS_Y.fget(this.getScope(), (PropertyHolder)this);
        Events.subscribe(EntityDamageByEntityEvent.class).filter(event -> event.getEntity() instanceof Player).handler(event -> this.ifEnchantPresent(event.getEntity(), enchantInfo -> this.checkShouldCast((Player)event.getEntity(), (EnchantInfo)enchantInfo))).bindWith((TerminableConsumer)this.getEnchantManager());
    }

    @Override
    public void handleCast(EnchantsProfile profile) {
        Player player = profile.getPlayer();
        profile.setOnCooldown(EnchantType.ENDER);
        player.spawnParticle(Particle.END_ROD, player.getLocation(), 5);
        player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        Location t = null;
        while (!(t = new Location(player.getWorld(), player.getLocation().getX() + Math.random() * (this.radius - this.radius * -1.0) + this.radius * -1.0, player.getLocation().getY() + Math.random() * (this.radiusY - this.radiusY * -1.0) + this.radiusY * -1.0, player.getLocation().getZ() + Math.random() * (this.radius - this.radius * -1.0) + this.radius * -1.0)).getBlock().isEmpty()) {
        }
        player.teleport(t);
    }

    @Override
    public void handleOnCooldown(EnchantsProfile profile, EnchantInfo enchantInfo) {
        Player player = profile.getPlayer();
        this.handleCooldownMessage(player, profile, enchantInfo);
    }
}

