/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.hardcoded;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.metadata.Pair;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythicenchants.enchants.EnchantManager;
import io.lumine.mythicenchants.enchants.hardcoded.HardcodedEnchantment;
import io.lumine.mythicenchants.enchants.properties.EnchantInfo;
import io.lumine.mythicenchants.enchants.properties.EnchantType;
import io.lumine.mythicenchants.profiles.EnchantsProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class CutCleanEnchant
extends HardcodedEnchantment {
    private static final Map<Material, Pair<Material, Integer>> RECIPES = Maps.newConcurrentMap();
    private static final Set<Material> FORTUNE_MATERIALS = Sets.newHashSet(Arrays.asList(Material.GOLD_INGOT, Material.IRON_INGOT));
    protected EnchantManager manager;

    public CutCleanEnchant(EnchantManager manager) {
        super(manager, EnchantType.CUTCLEAN);
        this.manager = manager;
        this.initializeEnchant();
    }

    @Override
    public void initializeEnchant() {
        Events.subscribe(BlockDropItemEvent.class).handler(event -> this.ifEnchantPresent((Entity)event.getPlayer(), enchantInfo -> {
            if (this.checkShouldCast(event.getPlayer(), (EnchantInfo)enchantInfo)) {
                event.getItems().clear();
                Player player = event.getPlayer();
                Location location = event.getBlock().getLocation().add(0.5, 0.5, 0.5);
                player.spawnParticle(Particle.FLAME, location, 5);
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_WORK_WEAPONSMITH, 0.5f, 1.75f);
                ArrayList drops = Lists.newArrayList();
                for (Item item : event.getItems()) {
                    drops.add(item.getItemStack());
                }
                int experience = 0;
                for (ItemStack itemStack : drops) {
                    Pair<Material, Integer> out = CutCleanEnchant.getOutput(itemStack.getType());
                    itemStack.setType((Material)out.getKey());
                    experience += ((Integer)out.getValue()).intValue();
                    location.getWorld().dropItemNaturally(location, itemStack);
                }
            }
        })).bindWith((TerminableConsumer)this.manager);
    }

    @Override
    public void handleCast(EnchantsProfile profile) {
    }

    private static Pair<Material, Integer> getOutput(Material input) {
        Pair<Material, Integer> toReturn = RECIPES.get(input);
        if (toReturn == null) {
            return Pair.of((Object)input, (Object)0);
        }
        return toReturn;
    }

    static {
        Iterator iterator = Bukkit.recipeIterator();
        while (iterator.hasNext()) {
            Recipe recipe = (Recipe)iterator.next();
            if (!(recipe instanceof FurnaceRecipe)) continue;
            FurnaceRecipe furnaceRecipe = (FurnaceRecipe)recipe;
            int xp = (int)Math.ceil(furnaceRecipe.getExperience());
            RECIPES.put(furnaceRecipe.getInput().getType(), (Pair<Material, Integer>)Pair.of((Object)furnaceRecipe.getResult().getType(), (Object)xp));
        }
    }
}

