/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.custom;

import com.google.common.collect.Maps;
import io.lumine.mythic.api.MythicProvider;
import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.api.skills.SkillManager;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.metadata.Pair;
import io.lumine.mythic.core.config.MythicLineConfigImpl;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.stats.StatModifierType;
import io.lumine.mythic.core.utils.math.Functions;
import io.lumine.mythic.core.utils.math.Operators;
import io.lumine.mythicenchants.enchants.EnchantManager;
import io.lumine.mythicenchants.enchants.MythicEnchant;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;

public class CustomEnchantment
extends MythicEnchant {
    private final String internalName;
    private final String fileName;
    private MythicConfig config;
    private Map<SkillTrigger<?>, Queue<SkillMechanic>> mechanics = new HashMap();
    private Queue<SkillMechanic> timerMechanics = null;
    private Map<String, Pair<Expression, StatModifierType>> stats = Maps.newConcurrentMap();

    public CustomEnchantment(EnchantManager enchantManager, File file, String name, MythicConfig mythicConfig) {
        super(enchantManager, file, name);
        this.fileName = file.getAbsolutePath();
        this.internalName = name;
        this.setupSkills(mythicConfig);
        this.load();
    }

    public void setupSkills(MythicConfig mythicConfig) {
        this.config = mythicConfig;
        this.mechanics.clear();
        this.timerMechanics = null;
        SkillManager sm = MythicProvider.get().getSkillManager();
        List skills = mythicConfig.getStringList("Skills");
        for (String s : skills) {
            Matcher rMatcher;
            Pattern rPattern;
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Loading mechanic line: {0}", (Object[])new Object[]{s});
            s = MythicLineConfigImpl.unparseBlock((String)s);
            SkillMechanic ms = sm.getMechanic(s);
            int interval = 1;
            if (ms == null) continue;
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Base skill found.", (Object[])new Object[0]);
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"SkillTrigger is {0}", (Object[])new Object[]{ms.getTrigger()});
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Skill is {0}", (Object[])new Object[]{ms.getInternalName()});
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Skill is {0}", (Object[])new Object[]{ms.getTrigger().name()});
            if (s.contains("~onTimer")) {
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"SkillTrigger is Timer. Assigning skill to Timer...", (Object[])new Object[0]);
                rPattern = Pattern.compile("~onTimer:([0-9]+)");
                rMatcher = rPattern.matcher(s);
                rMatcher.find();
                try {
                    interval = Integer.parseInt(rMatcher.group(1));
                }
                catch (Exception e) {
                    MythicLogger.error((String)("Error parsing Timer skill, invalid interval specified (must be an integer). AbstractSkill=" + s));
                    continue;
                }
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)("AbstractSkill set on timer with interval " + interval), (Object[])new Object[0]);
                ms.setTimerInterval(interval);
                if (this.timerMechanics == null) {
                    this.timerMechanics = new LinkedList<SkillMechanic>();
                }
                this.timerMechanics.add(ms);
                continue;
            }
            if (s.contains("~onSignal:")) {
                String signal;
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"SkillTrigger is Signal.", (Object[])new Object[0]);
                rPattern = Pattern.compile("~onSignal:([a-zA-Z0-9_-]*)");
                rMatcher = rPattern.matcher(s);
                rMatcher.find();
                try {
                    signal = rMatcher.group(1);
                }
                catch (Exception e) {
                    MythicLogger.error((String)("Error parsing Signal skill, invalid signal specified (contains invalid characters). AbstractSkill=" + s));
                    continue;
                }
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)("AbstractSkill set on Signal with index " + signal), (Object[])new Object[0]);
                this.saveSkill(SkillTriggers.SIGNAL, ms);
                continue;
            }
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"SkillTrigger is NOT Timer. Assigning skill to regular skill tree...", (Object[])new Object[0]);
            this.saveSkill(ms.getTrigger(), ms);
        }
        this.stats.clear();
        List lstStats = this.config.getStringList("Stats");
        if (!lstStats.isEmpty()) {
            for (String stat : lstStats) {
                try {
                    String[] split = stat.split(" ");
                    String type = split[0];
                    Expression value = new ExpressionBuilder(split[1]).operator(Operators.operators).functions(Functions.functions).variable("L").build();
                    StatModifierType operation = split.length > 2 ? StatModifierType.get((String)split[2]) : StatModifierType.ADDITIVE;
                    Log.info((String)"EnchantStat load {1} {2} {3}", (Object[])new Object[]{type, value.toString(), operation});
                    this.stats.put(type, (Pair<Expression, StatModifierType>)Pair.of((Object)value, (Object)operation));
                }
                catch (Exception ex) {
                    MythicLogger.errorGenericConfig((MythicConfig)this.config, (String)("Invalid syntax for Stat line in Enchantment " + this.getPropertyNode() + ": " + stat));
                }
            }
        }
    }

    private void saveSkill(SkillTrigger trigger, SkillMechanic skill) {
        if (!this.mechanics.containsKey(trigger)) {
            this.mechanics.put(trigger, new LinkedList());
        }
        this.mechanics.get(trigger).add(skill);
    }

    public boolean hasMechanics(SkillTrigger triggerToCheck) {
        if (this.mechanics.containsKey(triggerToCheck)) {
            return true;
        }
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Enchantment {0} does not have any skills for trigger {1}", (Object[])new Object[]{this.internalName, triggerToCheck});
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"Enchantment {0} has skills for triggers:", (Object[])new Object[0]);
        for (SkillTrigger<?> trigger : this.mechanics.keySet()) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.SKILL_CHECK, (String)"- {0}", (Object[])new Object[]{trigger});
        }
        return false;
    }

    public Queue<SkillMechanic> getMechanics(SkillTrigger calledTrigger) {
        return this.mechanics.get(calledTrigger);
    }

    public boolean hasTimerSkills() {
        return this.timerMechanics != null;
    }

    public Queue<SkillMechanic> getTimerSkills() {
        return this.timerMechanics;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public Map<String, Pair<Expression, StatModifierType>> getStats() {
        return this.stats;
    }
}

