/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants;

import io.lumine.mythic.api.config.MythicConfig;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.core.config.IOHandler;
import io.lumine.mythic.core.config.IOLoader;
import io.lumine.mythic.core.config.MythicConfigImpl;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.enchants.EnchantManager;
import io.lumine.mythicenchants.enchants.MythicEnchant;
import io.lumine.mythicenchants.enchants.custom.CustomEnchantment;
import io.lumine.mythicenchants.enchants.hardcoded.EnderEnchant;
import io.lumine.mythicenchants.enchants.hardcoded.HardcodedEnchantment;
import io.lumine.mythicenchants.enchants.skills.CustomSkillHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.plugin.java.JavaPlugin;

public class EnchantmentFactory
extends ReloadableModule<MythicEnchants> {
    private final EnchantManager enchantManager;
    private List<File> enchantmentFiles;
    private CustomSkillHandler skillManager;
    private List<IOLoader<MythicEnchants>> enchantmentLoaders;
    private List<Runnable> secondPass = new ArrayList<Runnable>();

    public EnchantmentFactory(MythicEnchants plugin, EnchantManager enchantManager) {
        super((LuminePlugin)plugin, false);
        Log.info((String)"Loading CustomEnchantManager...");
        this.enchantManager = enchantManager;
        this.skillManager = new CustomSkillHandler(plugin);
    }

    private void loadEnchantments() {
        Log.info((String)"Loading Mythic Enchantments...");
        String exampleFileName = "CustomEnchantments/ExampleEnchantments.yml";
        File tempDir = new File(String.valueOf(((MythicEnchants)this.getPlugin()).getDataFolder()) + File.separator + "CustomEnchantments");
        if (new File(((MythicEnchants)this.getPlugin()).getDataFolder(), "CustomEnchantments/ExampleEnchantments.yml").exists()) {
            Log.info((String)"+ Loading ExampleEnchants.yml");
        } else {
            Log.info((String)"+ Generating ExampleEnchants.yml");
            ((MythicEnchants)this.getPlugin()).saveResource("CustomEnchantments/ExampleEnchantments.yml", false);
        }
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        this.initialiseEnchantmentLoaders();
        this.handlePacks();
        this.registerEnchantments();
        this.runSecondPass();
    }

    private void registerEnchantments() {
        this.registerCustomEnchantments();
        this.registerHardcodedEnchantments();
    }

    private void runSecondPass() {
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("Doing second pass on " + this.secondPass.size() + " enchantments."), (Object[])new Object[0]);
        this.secondPass.forEach(r -> r.run());
        this.secondPass.clear();
    }

    public void load(MythicEnchants mythicEnchants) {
        this.loadEnchantments();
    }

    public void unload() {
    }

    private void addEnchantmentFiles(String packageName, File packFolder) {
        File confFolder = new File(packFolder.getAbsolutePath() + System.getProperty("file.separator") + packageName);
        if (confFolder.exists() && confFolder.isDirectory()) {
            this.enchantmentFiles.addAll(IOHandler.getAllFiles((String)confFolder.getAbsolutePath()));
        }
    }

    private void handlePacks() {
        File packsFolder = new File(String.valueOf(((MythicEnchants)this.getPlugin()).getDataFolder()) + System.getProperty("file.separator") + "Packs");
        if (packsFolder.exists() && packsFolder.isDirectory()) {
            for (File packFolder : packsFolder.listFiles()) {
                if (!packFolder.isDirectory()) continue;
                this.addEnchantmentFiles("CustomEnchantments", packFolder);
                this.addEnchantmentFiles("Enchantments", packFolder);
                this.addEnchantmentFiles("Enchants", packFolder);
            }
        }
    }

    private void registerCustomEnchantments() {
        Log.info((String)"Loading Custom Enchantments...");
        Map<String, MythicEnchant> enchantments = this.enchantManager.getEnchantments();
        Map<String, MythicEnchant> enchantmentsDisplay = this.enchantManager.getEnchantmentsDisplay();
        int count = 0;
        for (IOLoader<MythicEnchants> sl : this.enchantmentLoaders) {
            for (String name : sl.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                MythicConfigImpl mythicConfig = new MythicConfigImpl(name, sl.getCustomConfig());
                if (!enchantments.containsKey(name.toUpperCase())) {
                    CustomEnchantment customEnchantment = new CustomEnchantment(this.enchantManager, sl.getFile(), name, (MythicConfig)mythicConfig);
                    this.enchantManager.register(customEnchantment);
                    enchantments.put(name, customEnchantment);
                    enchantmentsDisplay.put(name.toUpperCase(), customEnchantment);
                } else {
                    MythicEnchant enchant = enchantments.get(name.toUpperCase());
                    if (enchant instanceof CustomEnchantment) {
                        CustomEnchantment customEnchantment = (CustomEnchantment)enchant;
                        customEnchantment.setupSkills((MythicConfig)mythicConfig);
                        enchantmentsDisplay.put(customEnchantment.getName(), customEnchantment);
                    }
                }
                ++count;
            }
        }
        Log.info((String)"Loaded {0} custom enchantments", (Object[])new Object[]{count});
    }

    private void registerHardcodedEnchantments() {
        Log.info((String)"Loading Hardcoded Enchantments...");
        int count = 0;
        for (HardcodedEnchantment enchant : this.getHardcodedEnchants()) {
            this.registerHardCodedEnchant(enchant);
            ++count;
        }
        Log.info((String)"Loaded {0} hardcoded enchantments", (Object[])new Object[]{count});
    }

    private void initialiseEnchantmentLoaders() {
        this.enchantmentFiles = IOHandler.getAllFiles((String)(String.valueOf(((MythicEnchants)this.getPlugin()).getDataFolder()) + File.separator + "CustomEnchantments"));
        this.enchantmentLoaders = IOHandler.getSaveLoad((JavaPlugin)MythicEnchants.inst(), this.enchantmentFiles, (String)"CustomEnchantments");
    }

    private Set<HardcodedEnchantment> getHardcodedEnchants() {
        HashSet<HardcodedEnchantment> enchants = new HashSet<HardcodedEnchantment>();
        enchants.add(new EnderEnchant(this.enchantManager));
        return enchants;
    }

    private void registerHardCodedEnchant(HardcodedEnchantment enchant) {
        this.enchantManager.register(enchant);
        this.enchantManager.getEnchantments().put(enchant.getPropertyNode().toUpperCase(), enchant);
        this.enchantManager.getEnchantmentsDisplay().put(enchant.getDisplayName(), enchant);
    }
}

