/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.commands.sub;

import io.lumine.mythic.bukkit.utils.commands.Command;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.commands.CommandHelper;
import io.lumine.mythicenchants.constants.CommandPermissions;
import io.lumine.mythicenchants.profiles.EnchantsProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.StringUtil;

public class EnchantAddCommand
extends Command<MythicEnchants> {
    public EnchantAddCommand(Command<MythicEnchants> parent) {
        super(parent);
    }

    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 1) {
            CommandHelper.sendError(sender, "Command Syntax: /me enchant <enchantment> [level]");
            return true;
        }
        Player target = (Player)sender;
        String strEnchant = args[0];
        int level = 1;
        if (args.length > 1) {
            level = Integer.valueOf(args[1]);
        }
        if (target == null) {
            CommandHelper.sendError(sender, "That player is not online");
            return true;
        }
        try {
            ItemStack item = Objects.requireNonNull(target.getInventory().getItemInMainHand());
            if (!((MythicEnchants)this.getPlugin()).getEnchantManager().isRegistered(strEnchant)) {
                CommandHelper.sendError(sender, "Enchantment doesnt exist");
                return true;
            }
            ((MythicEnchants)this.getPlugin()).getEnchantManager().applyEnchantment(item, strEnchant, level);
            ((EnchantsProfile)((MythicEnchants)this.getPlugin()).getProfileManager().getProfile(target)).parseWeapons();
            CommandHelper.sendSuccess(sender, "Enchantment applied to item.");
            return true;
        }
        catch (NullPointerException nullPointerException) {
            CommandHelper.sendError(sender, "No item in hand to Enchant!");
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)nullPointerException.getMessage(), (Object[])new Object[0]);
            return true;
        }
    }

    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], MythicEnchants.inst().getEnchantManager().getEnchantmentNames(), new ArrayList());
        }
        return Collections.emptyList();
    }

    public String getPermissionNode() {
        return CommandPermissions.PERMISSION_COMMAND_ENCHANT.getPermissionString();
    }

    public boolean isConsoleFriendly() {
        return false;
    }

    public String getName() {
        return "enchant";
    }

    public String[] getAliases() {
        return new String[]{"e"};
    }
}

