/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants;

import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.chat.ColorString;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersion;
import io.lumine.mythic.bukkit.utils.version.MinecraftVersions;
import io.lumine.mythic.bukkit.utils.version.ServerVersion;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythicenchants.api.volatilecode.VolatileCodeHandler;
import io.lumine.mythicenchants.commands.BaseCommand;
import io.lumine.mythicenchants.compat.CompatibilityManager;
import io.lumine.mythicenchants.config.Configuration;
import io.lumine.mythicenchants.enchants.EnchantManager;
import io.lumine.mythicenchants.enchants.loot.LootEventManager;
import io.lumine.mythicenchants.enchants.skills.triggers.EnchantedItemTriggers;
import io.lumine.mythicenchants.metrics.bStats;
import io.lumine.mythicenchants.profiles.EnchantsProfileManager;
import io.lumine.mythicenchants.volatilecode.NoNMSHandler;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;

public class MythicEnchants
extends LuminePlugin {
    private static MythicEnchants plugin;
    private Configuration configuration;
    private EnchantManager enchantManager;
    private EnchantsProfileManager profileManager;
    private LootEventManager lootEventManager;
    private CompatibilityManager compatibilityManager;
    private VolatileCodeHandler volatileCodeHandler;
    private boolean MMOCore = false;
    private String CONFIG_PATH = "config.yml";
    private String RARITIES_PATH = "rarities.yml";
    private Boolean factionsEnabled;
    private long clockTimer = 0L;

    public void load() {
        plugin = this;
        EnchantedItemTriggers.register();
    }

    public void enable() {
        Log.info((String)(String.valueOf(ChatColor.GOLD) + "-------------------------------------------------"));
        Log.info((String)(String.valueOf(ChatColor.AQUA) + "+ Loading MythicEnchants for Spigot"));
        Log.info((String)(String.valueOf(ChatColor.GOLD) + "-------------------------------------------------"));
        this.initialiseConfig(this.CONFIG_PATH);
        this.initialiseConfig(this.RARITIES_PATH);
        Log.info((String)"+ Binding Configuration");
        this.configuration = new Configuration(this);
        this.bind((AutoCloseable)((Object)this.configuration));
        Log.info((String)"+ Loading Volatile Code Handler");
        this.getVolatileCodeHandler();
        Log.info((String)"+ Initialising Managers");
        this.initialiseManagers();
        if (Bukkit.getPluginManager().isPluginEnabled("MMOCore")) {
            this.MMOCore = true;
        }
        this.loadManagers();
        this.registerCommand("mythicenchants", (CommandExecutor)new BaseCommand(this));
        Schedulers.sync().runRepeating(() -> this.getProfileManager().runTimerSkills(this.clockTimer++), 0L, (long)this.configuration.getClockInterval()).bindWith((TerminableConsumer)this);
        new bStats(this);
    }

    private void initialiseConfig(String configPath) {
        if (new File(this.getDataFolder(), configPath).exists()) {
            Log.info((String)("+ Loading " + configPath));
        } else {
            Log.info((String)("+ Generating " + configPath));
            this.saveResource(configPath, false);
        }
    }

    private void initialiseManagers() {
        Log.info((String)"+ Initialising Profile Manager");
        this.profileManager = new EnchantsProfileManager(this);
        Log.info((String)"+ Initialising Enchant Manager");
        this.enchantManager = new EnchantManager(this);
        Log.info((String)"+ Initialising Compatibility Manager");
        this.compatibilityManager = new CompatibilityManager(this);
        Log.info((String)"+ Initialising Loot Event Manager");
        this.lootEventManager = new LootEventManager(this, this.enchantManager);
        Log.info((String)"+ Managers Initialised");
    }

    private void loadManagers() {
        this.bind((AutoCloseable)((Object)this.profileManager));
        this.profileManager.load(this);
        this.bind((AutoCloseable)((Object)this.enchantManager));
        this.enchantManager.load(this);
        this.bind((AutoCloseable)((Object)this.lootEventManager));
        this.lootEventManager.load(this);
    }

    public void disable() {
        this.configuration.unload();
    }

    public static MythicEnchants inst() {
        return plugin;
    }

    public MythicBukkit core() {
        return MythicBukkit.inst();
    }

    public VolatileCodeHandler getVolatileCodeHandler() {
        if (this.volatileCodeHandler != null) {
            return this.volatileCodeHandler;
        }
        this.volatileCodeHandler = new NoNMSHandler();
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        String version = packageName.substring(packageName.lastIndexOf(46) + 1);
        if (ServerVersion.isBeforeOrEq((MinecraftVersion)MinecraftVersions.v1_20_2)) {
            version = "v1_1_R0";
        }
        try {
            Class<?> clazz = Class.forName("io.lumine.mythicenchants.volatilecode.NMSHandler_" + version);
            if (VolatileCodeHandler.class.isAssignableFrom(clazz)) {
                this.volatileCodeHandler = (VolatileCodeHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            MythicLogger.error((String)ColorString.get((String)"&6--====|||| &c&lMythicEnchants &6||||====--"));
            MythicLogger.error((String)"This version of MythicEnchants is not fully compatible with your version of Bukkit.");
            MythicLogger.error((String)"Some features may be limited or disabled until you use a compatible version.");
            MythicLogger.error((String)"Server NMS Version Detected - {0}", (Object[])new Object[]{version});
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown exception loading version handler. Volatile code has been disabled.", e);
        }
        return this.volatileCodeHandler;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public EnchantManager getEnchantManager() {
        return this.enchantManager;
    }

    public EnchantsProfileManager getProfileManager() {
        return this.profileManager;
    }

    public LootEventManager getLootEventManager() {
        return this.lootEventManager;
    }

    public CompatibilityManager getCompatibilityManager() {
        return this.compatibilityManager;
    }

    public boolean isMMOCore() {
        return this.MMOCore;
    }

    public Boolean getFactionsEnabled() {
        return this.factionsEnabled;
    }
}

