/*
 * Decompiled with CFR 0.152.
 */
package com.sainttx.holograms.util;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TextUtil {
    public static String color(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static String locationAsString(Location location) {
        return location.getWorld().getName() + " (x/y/z: " + TextUtil.formatDouble(location.getX()) + "/" + TextUtil.formatDouble(location.getY()) + "/" + TextUtil.formatDouble(location.getZ()) + ")";
    }

    public static String formatDouble(double value) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        return nf.format(value);
    }

    public static ItemStack parseItem(String text) {
        int amount;
        Material material;
        String[] split = text.split(" ");
        int durability = -1;
        String data = split[0];
        if (data.contains(":")) {
            String[] datasplit = data.split(":");
            data = datasplit[0];
            durability = Short.parseShort(datasplit[1]);
        }
        Material material2 = material = data.matches("[0-9]+") ? Material.getMaterial((int)Integer.parseInt(data)) : Material.getMaterial((String)data.toUpperCase());
        if (material == null) {
            throw new IllegalArgumentException("Invalid material " + data);
        }
        try {
            amount = split.length == 1 ? 1 : Integer.parseInt(split[1]);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid amount \"" + split[1] + "\"", ex);
        }
        ItemStack item = new ItemStack(material, amount, (short)Math.max(0, durability));
        ItemMeta meta = item.getItemMeta();
        if (split.length < 3) {
            return item;
        }
        block12: for (int i = 2; i < split.length; ++i) {
            String[] information = split[i].split(":");
            switch (information[0].toLowerCase()) {
                case "name": {
                    String name = information[1].replace(' ', ' ');
                    meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
                    continue block12;
                }
                case "lore": {
                    String[] loreLines;
                    List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                    for (String line : loreLines = information[1].split("\\|")) {
                        line = line.replace('_', ' ');
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                    }
                    meta.setLore(lore);
                    continue block12;
                }
                case "data": {
                    short dataValue = Short.parseShort(information[1]);
                    item.setDurability(dataValue);
                }
                default: {
                    Enchantment ench = Enchantment.getByName((String)information[0].toUpperCase());
                    int level = Integer.parseInt(information[1]);
                    if (ench != null) {
                        meta.addEnchant(ench, level, true);
                        continue block12;
                    }
                    throw new IllegalArgumentException("Invalid enchantment " + information[0]);
                }
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    public static String implode(String[] toImplode) {
        return TextUtil.implode(0, toImplode);
    }

    public static String implode(int startIndex, String[] toImplode) {
        return TextUtil.implode(startIndex, toImplode, " ");
    }

    public static String implode(int startIndex, String[] toImplode, String spacer) {
        StringBuilder ret = new StringBuilder();
        for (int i = startIndex; i < toImplode.length; ++i) {
            if (toImplode[i] != null) {
                ret.append(toImplode[i]);
            }
            if (i >= toImplode.length - 1) continue;
            ret.append(spacer);
        }
        return TextUtil.color(ret.toString().trim());
    }
}

